/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** blackHolewarp.cpp
*/
#include "blackholewarp.h"

blackHoleWarp::blackHoleWarp(textureBase *p):textureBase(BLACKHOLEWARP,p)
{
	setName("Blackhole-Warp");
	setInfo("Blackhole-Warp");
	setSubItems(false);

	location=Vector3(0,0,0);	
	repeat=Vector3(0,0,0);
	turbulence=Vector3(0,0,0);
	radius=0;
	falloff=0;
	strength=0;
	inverse=true;
}

blackHoleWarp::~blackHoleWarp()
{
}

void blackHoleWarp::setLocation(Vector3 x)
{
	location=x;
}

Vector3	blackHoleWarp::getLocation()
{
	return location;
}

void 	blackHoleWarp::setRepeat(Vector3 x)
{
	repeat=x;
}

Vector3	blackHoleWarp::getRepeat()
{
	return repeat;
}

void blackHoleWarp::setTurbulence(Vector3 x)
{
	turbulence=x;
}

Vector3	blackHoleWarp::getTurbulence()
{
	return turbulence;
}

void	blackHoleWarp::setRadius(double x)
{
	radius=x;
}

double	blackHoleWarp::getRadius()
{
	return radius;
}

void	blackHoleWarp::setFallOff(double x)
{
	falloff=x;
}

double	blackHoleWarp::getFallOff()
{
	return falloff;
}

void	blackHoleWarp::setStrength(double x)
{
	strength=x;
}

double	blackHoleWarp::getStrength()
{
	return strength;
}

void	blackHoleWarp::setInverse(bool x)
{
	inverse=x;
}

bool	blackHoleWarp::getInverse()
{
	return inverse;
}


int	blackHoleWarp::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	#ifdef DEBUG
		printf("Loading Warp\n");
	#endif

	if(!m) return -1;
	setMedia(m);	
	

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"DATA",4) == 0) {
			location=readVector();
			m->read(&radius,sizeof(double) );
			repeat=readVector();
			turbulence=readVector();
			m->read(&falloff,sizeof(double) );
		       	m->read(&strength,sizeof(double) );
		       	m->read(&inverse,sizeof(bool) );
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("blackHoleWarp loaded\n");
	#endif
	//updateInfo();
	return 0;
}



int blackHoleWarp::save(media *m)
{
chunk ch;
	if(!m)	return -1;
	#ifdef DEBUG
		printf("saving blackHoleWarp\n");
	#endif

	setMedia(m);

	writeChunk("WRPB");

	textureBase::save(m);

	ch.setMedia(m);
	ch.writeChunk("DATA");

	writeVector(location);
	m->write(&radius,sizeof(double) );
	writeVector(repeat);
	writeVector(turbulence);
	m->write(&falloff,sizeof(double) );
       	m->write(&strength,sizeof(double) );
       	m->write(&inverse,sizeof(bool) );

	ch.writeChunkLen();
		

	writeChunkLen();

	#ifdef DEBUG
		printf("blackHoleWarp saved\n");
	#endif
	return 0;
}

int blackHoleWarp::exportPOV(FILE *fp,int tab,int tabsize, int anim,bool dummy)
{
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting blackHoleWarp (POV)\n");
	#endif

	printTab(fp,tab);
	fprintf(fp,"black_hole <%g,%g,%g>, %g\n",location[0],location[1],location[2],radius);


	if ((repeat[0]!=0)&&(repeat[1]!=0)||(repeat[2]!=0)) {
		printTab(fp,tab);
		fprintf(fp,"repeat     <%g,%g,%g>\n",turbulence[0],turbulence[1],turbulence[2]);
	}

	if (strength!=0) {
		printTab(fp,tab);
		fprintf(fp,"strength %g\n",strength);
	}


	if (falloff!=0) {
		printTab(fp,tab);
		fprintf(fp,"falloff %g\n",falloff);
	}

	if (inverse==true) {
		printTab(fp,tab);
		fprintf(fp,"inverse\n");
	}

        if ((turbulence[0]!=0)&&(turbulence[1]!=0)||(turbulence[2]!=0)) {
		printTab(fp,tab);
		fprintf(fp,"turbulence     <%g,%g,%g>\n",turbulence[0],turbulence[1],turbulence[2]);
	}

	textureBase::exportPOV(fp,tab+tabsize,tabsize,anim,dummy);


	#ifdef DEBUG
		printf("blackHoleWarp exported (POV) saved\n");
	#endif
	return 0;
}


