/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorlist.cpp
*/
#include "colorlist.h"

#include <misc.h>


static char	fnname[colorList::NFunctions][20] =
		{
		"brick",
		"checker",
		"hexagon"
		};


colorList::colorList(textureBase *p):textureBase(COLORLIST,p)
{

	fn=Checker;

	setName("Colorlist");
	setInfo("Colorlist");
	setSubItems(true);

	addAddableItem(COLOR,true);
	addAddableItem(COLORENTRY,false);
	addAddableItem(COLORMAP,false);
	addAddableItem(COLORLIST,false);
	addAddableItem(TURBULENCEMODIFIER,true);

}

void	colorList::setActive(bool a,textureBase *tb)
{
	if (tb==NULL) {textureBase::setActive(a);return;}
	if (tb->getType()==COLORLIST) textureBase::setActive(a);
	else tb->setActive(a);
}

void colorList::addElement(textureBase* what,textureBase* where)
{
        if(!what) return;
	what->setParent(this);
	what->setActive(true);
	
	switch(what->getType()) {
	case COLORMAP:
		{
			textureBase *tb=what->getFirstElement();
			while (tb!=NULL) {
				color *c=new color(this);
				c->add(tb);
				elements.append(c);
				tb=what->getNextElement();
			}
		}
	break;
	case COLORENTRY:
		{
			color *c=new color(this);
			c->add(what);
			elements.append(c);

		}
	break;
	default:
		textureBase::addElement(what,where);
	break;
	}
	updateInfo();
}



bool colorList::isEqual(textureBase *tb)
{
colorList *cl=(colorList *)tb;
#ifdef DEBUG
	printf("Comparing Colorlist...\n");
#endif
	if (!tb) return false;
	if (textureBase::isEqual(tb)==false) return false;
	if (cl->getColorListFunction()!=fn) return false;
#ifdef DEBUG
	printf("Comparing Colorlist...found !\n");
#endif
	return true;
}

colorList::~colorList()
{
}

void colorList::updateInfo()
{
char *buffer=(char *)malloc(512);
	sprintf(buffer,"Pattern:%s",getColorListFunctionName());
	setInfo(buffer);
	free(buffer);
}

void colorList::setColorListFunction(FUNCTION f)
{
	fn=f;
	updateInfo();
}

int colorList::getColorListFunction()
{
	return fn;
}

char *colorList::getColorListFunctionName()
{
	return fnname[fn];
}

char *colorList::getColorListFunctionNameList(int n)
{
	return fnname[n];
}

int	colorList::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	
	#ifdef DEBUG
		printf("loading ColorList\n");
	#endif

	setMedia(m);

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"COLR",4) == 0) {
			color *col=new color(this);
			col->load(m,len);
			addElement(col,NULL);
			read=true;
		}
		if(strncmp(chunk,"CLFN",4) == 0) {
			m->read(&fn,4);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}

		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );


	m->seek(pos+l,SEEK_SET);

	#ifdef DEBUG
		printf("ColorList loaded\n");
	#endif

	updateInfo();
	return 0;
}

void	colorList::add(textureBase *tb)
{
	if (tb==NULL) return;
	if (canAdd(tb)==false) return;
	addElement(tb,NULL);

	updateInfo();
}


int	colorList::save(media *m)
{
int i;
chunk ch;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving ColorList\n");
	#endif
	setMedia(m);

	writeChunk("COLL");

	textureBase::save(m);
        ch.setMedia(m);
	ch.writeChunk("CLFN");
		m->write(&fn,4);
	ch.writeChunkLen();

	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}

	writeChunkLen();

	#ifdef DEBUG
		printf("ColorList saved\n");
	#endif
	return 0;
}

int colorList::exportPOV(FILE *fp,int tab,int tabsize,int a, bool dummy)
{
int i;
color *c;
	if(fp == 0)
		return -1;
	#ifdef DEBUG
		printf("exporting ColorList (POV)\n");
	#endif
	
	printTab(fp,tab);
	fprintf(fp,"%s  //%s\n",getColorListFunctionName(),getName() );

	for (i=0;i<elements.length();i++) {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==COLOR)) {
                		c=(color *)elements[i];
				printTab(fp,tab);
				fprintf(fp,"color rgbt <%g, %g, %g, %g>,\n",c->red(),c->green(),c->blue(),c->transparency() );
		}
	}
	textureBase::exportPOV(fp,tab,tabsize,a,dummy);
	#ifdef DEBUG
		printf("ColorList exported (POV)\n");
	#endif

	return 0;
}
