/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normalentry.cpp
*/
#include "normalentry.h"


normalEntry::normalEntry(textureBase *p):textureBase(NORMALENTRY,p)
{
normalEntry *ne;
double x;
	#ifdef DEBUG
		printf("entering Normalentry-Constructor\n");
	#endif
        usePattern=false;
	range=0.1;

	parent=p;
	setName("Normal-Entry");
	setInfo("Normal-Entry");	
	setSubItems(true);

	if (p!=NULL) {
		ne=(normalEntry *)(p->getFirstElement());
		while (ne!=NULL) {
			#ifdef DEBUG
			printf("x=%g   range=%g\n",x,ne->getRange() );
			#endif
			if (ne->getRange()>=x) x=ne->getRange()+0.1;
			ne=(normalEntry *)(p->getNextElement());
		}
		if (x>1) x=1.0;
		setRange(x);
	}

	addAddableItem(NORMAL,false);
	addAddableItem(NORMALENTRY,false);
	addAddableItem(NORMALLIST,true);
	addAddableItem(NORMALMAP,true);
	addAddableItem(BUMPMAP,true);
	addAddableItem(SLOPEMAP,true);
	addAddableItem(TRANSFORMATIONS,true);
	addAddableItem(TURBULENCEMODIFIER,true);

	//updateInfo();

	#ifdef DEBUG
		printf("exiting normal-Constructor\n");
	#endif
}

patternmodifier *normalEntry::getMapModifier()
{
	return &modifier;
}


bool normalEntry::getUsePattern()
{
	return usePattern;
}

void normalEntry::setUsePattern(bool a)
{
	usePattern=a;
}

normalEntry::~normalEntry()
{
}

void	normalEntry::setActive(bool a,textureBase *tb)
{
int i;

	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}


	if ((tb->getType()==TURBULENCEMODIFIER)||
	     (tb->getType()==TRANSFORMATIONS)) {
			tb->setActive(a);
			return;
	}

	if (a==false) return;
	for (i=0;i<elements.length();i++) elements[i]->setActive(false);
	tb->setActive(true);
}

void normalEntry::addElement(textureBase* what,textureBase* where)
{
	if (what==NULL) return;
	what->setParent(this);
	setActive(true,what);
	what->setParent(this);
	setActive(true,what);

	switch(what->getType() )
	{
	case NORMAL:
	{
	textureBase *tb=what->getFirstElement();
		while(tb!=NULL) {
			elements.append(tb);
			tb=what->getNextElement();					
		}
	}
	break;
	default:
		textureBase::addElement(what,where);
	break;
	}
}

bool normalEntry::isEqual(textureBase *tb)
{
#ifdef DEBUG
	printf("Comparing Normals..\n");
#endif

	if (textureBase::isEqual(tb)==false) return false;

	if ( ((normalEntry*)tb)->getRange()!=getRange()) return false;

#ifdef DEBUG
	printf("Compared Normals..found it !\n");
#endif
	return true;
}

void normalEntry::add(textureBase *tb)
{
int t;
	if (!tb) return;
	t=tb->getType();
	if ( canAdd(tb)==true) {
		tb->setParent(this);	
		addElement( tb,NULL);
	}
}

bool normalEntry::isExportable()
{
	return true;
}

void	normalEntry::setRange(double n)
{
	range=n;
}

double	normalEntry::getRange()
{
	return range;
}


int	normalEntry::save(media *m)
{	
chunk ch;
int i;

	if(!m) return -1;
	#ifdef DEBUG
		printf("saving normalEntry\n");
	#endif
	setMedia(m);
	
	writeChunk("NRME");

	textureBase::save(m);

	ch.setMedia(m);
	ch.writeChunk("DATA");
        		m->write(&range,sizeof(double) );
			m->write(&usePattern,sizeof(bool));			
	ch.writeChunkLen();

	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}

	writeChunkLen();	

	#ifdef DEBUG
		printf("NormalEntry saved\n");
	#endif

	return 0;
}

int	normalEntry::load(media *m,int l)
{
	char	chunk[4];
	int	len,pos = m->tell();
	bool	read;

	if(!m)	return -1;

	setMedia(m);

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"DATA",4) == 0) {
			m->read(&range,sizeof(double) );
			m->read(&usePattern,sizeof(bool));			
			read=true;
		}
		if(strncmp(chunk,"BMPM",4) == 0) {
			bumpMap *bumMap=new bumpMap(this);
			bumMap->load(m,len);
			addElement(bumMap,NULL);
			read=true;
		}
		if(strncmp(chunk,"SLPM",4) == 0) {
			slopeMap *sMap=new slopeMap(this);
			sMap->load(m,len);
			addElement(sMap,NULL);
			read=true;
		}
		if(strncmp(chunk,"NRMM",4) == 0) {
			normalMap *nMap=new normalMap(this);
			nMap->load(m,len);
			elements.append((textureBase*)nMap);
			read=true;
		}
		if(strncmp(chunk,"NRLL",4) == 0) {
			normalList *nList=new normalList(this);
			nList->load(m,len);
			elements.append((textureBase*)nList);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *tr=new Transformations(this);
			tr->load(m,len);
			addElement(tr,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);		
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }
	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

     	return 0;
}

int	normalEntry::exportPOV(FILE *fp,int tab,int tabsize, int a,bool dummy)
{
int i;

	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting normalEntry (POV)\n");
	#endif
	printTab(fp,tab);
	fprintf(fp,"[ %g   //%s\n",range,getName() );

	if (usePattern) modifier.exportPOV(fp,tab+tabsize,tabsize,a,false);
	else {

		for (i=0;i<elements.length();i++) {
			if (elements[i]->active()==true) {
			elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,false);
			}
		}
	}
	printTab(fp,tab);
	fprintf(fp,"]\n");
	
	textureBase::exportPOV(fp,tab,tabsize,a,dummy);

	#ifdef DEBUG
		printf("NormalEntry exported (POV)\n");
	#endif
	return 0;
}

