/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigment.h
*/
#ifndef __PIGMENTENTRY_H__
#define __PIGMENTENTRY_H__

#include "color.h"
#include "colorlist.h"
#include "colormap.h"
#include "pigmentmap.h"
#include "pigmentlist.h"
#include "imagemap.h"
#include "patternmodifier.h"

#include "texturebase.h"
#include "transformations.h"
#include "turbulence.h"
#include <list.h>

class pigmentMap;
class pigmentList;

class pigmentEntry : public textureBase
{

protected:
		
	color		*quickcolor;
	double		range;
	
public:

	pigmentEntry(textureBase *p=NULL);
	~pigmentEntry();

        char	*getInfo();

	void	addElement(textureBase *,textureBase *a=NULL);

	void	setQuickColor(color *);
	color *getQuickColor(textureBase *);

	const char **getXPM();
	
	void	setActive(bool a,textureBase *tb);

	void	setRange(double);
	double	getRange();

	bool	isEqual(textureBase *);
	void 	add(textureBase *);

	int	load(media*,int);
	int	save(media*);

	int	exportPOV(FILE*,int,int,int,bool);
};


#endif
