/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** surfacelist.cpp
*/
#include "surfacelist.h"

#include <misc.h>


static char	fnname[surfaceList::NFunctions][20] =
		{
		"brick",
		"checker",
		"hexagon"
		};


surfaceList::surfaceList(textureBase *p):textureBase(SURFACELIST,p)
{

	fn=Checker;

	setName("Surfacelist");
	setInfo("Surfacelist");
	setSubItems(true);

	addAddableItem(SURFACE,true);
	addAddableItem(TURBULENCEMODIFIER,true);
	addAddableItem(TRANSFORMATIONS,true);
}


void	surfaceList::setActive(bool a,textureBase *tb)
{
	if (tb==NULL) {textureBase::setActive(a);return;}
	if (tb->getType()==SURFACELIST) textureBase::setActive(a);
	else tb->setActive(a);
}

void surfaceList::addElement(textureBase* what,textureBase* where)
{
        if(!what) return;
	what->setParent(this);
	what->setActive(true);

	switch(what->getType()) {

	case COLOR:
	case COLORLIST:
	case COLORMAP:
	case IMAGEMAP:
	case BUMPMAP:
	case SLOPEMAP:
	case NORMALLIST:
	case NORMALMAP:
	case FINISH:
	case PIGMENT:
	case NORMAL:
	{
		surface *s=new surface(this);
		s->add(what);
		elements.append(s);
	}
	break;
	case SURFACE:
		elements.append(what);
	break;
	default:
		textureBase::addElement(what,where);
	break;
	updateInfo();
	}
}



bool surfaceList::isEqual(textureBase *tb)
{

#ifdef DEBUG
	printf("Comparing Surfacelist...\n");
#endif
	if (!tb) return false;
	if (textureBase::isEqual(tb)==false) return false;
	if ( ((surfaceList*)tb)->getSurfaceListFunction()!=fn) return false;
#ifdef DEBUG
	printf("Comparing Surfacelist...found !\n");
#endif
	return true;
}

surfaceList::~surfaceList()
{
}

void surfaceList::updateInfo()
{
char *buffer=(char *)malloc(512);
	sprintf(buffer,"Pattern:%s",getSurfaceListFunctionName());
	setInfo(buffer);
	free(buffer);
}

void surfaceList::setSurfaceListFunction(FUNCTION f)
{
	fn=f;
	updateInfo();
}

int surfaceList::getSurfaceListFunction()
{
	return fn;
}

char *surfaceList::getSurfaceListFunctionName()
{
	return fnname[fn];
}

char *surfaceList::getSurfaceListFunctionNameList(int n)
{
	return fnname[n];
}

int	surfaceList::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	
	#ifdef DEBUG
		printf("loading SurfaceList\n");
	#endif

	setMedia(m);

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"TXTR",4) == 0) {
			surface *s;
			elements.append ( (s=new surface(this)) );
			s->load(m,len);
			read=true;
		}
		if(strncmp(chunk,"TXTF",4) == 0) {
			m->read(&fn,4);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}

		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );


	m->seek(pos+l,SEEK_SET);

	#ifdef DEBUG
		printf("SurfaceList loaded\n");
	#endif

	updateInfo();
	return 0;
}


void	surfaceList::add(textureBase *tb)
{
	if (tb==NULL) return;
	if (canAdd(tb)==false) return;
	addElement(tb,NULL);

	updateInfo();
}


int	surfaceList::save(media *m)
{
int i;
chunk ch;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving SurfaceList\n");
	#endif
	setMedia(m);

	writeChunk("TXTL");

	textureBase::save(m);
        ch.setMedia(m);
	ch.writeChunk("TXTF");
		m->write(&fn,4);
	ch.writeChunkLen();

	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}

	writeChunkLen();

	#ifdef DEBUG
		printf("SurfaceList saved\n");
	#endif
	return 0;
}

int surfaceList::exportPOV(FILE *fp,int tab,int tabsize,int a, bool dummy)
{
int i;

	if(fp == 0)
		return -1;
	#ifdef DEBUG
		printf("exporting SurfaceList (POV)\n");
	#endif
	
	printTab(fp,tab);
	fprintf(fp,"%s  //%s\n",getSurfaceListFunctionName(),getName() );


	for (i=0;i<elements.length();i++) {
		if ((elements[i]->active()==true)&&(elements[i]->getType()!=TURBULENCEMODIFIER)&&(elements[i]->getType()!=TRANSFORMATIONS)) {
				printTab(fp,tab);

				elements[i]->exportPOV(fp,tab+tabsize,tab,a,false);
				printTab(fp,tab);

		}
	}
	
	textureBase::exportPOV(fp,tab,tabsize,a,dummy);

	#ifdef DEBUG
		printf("SurfaceList exported (POV)\n");
	#endif

	return 0;
}
