/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** aboutdialog.cpp
*/
#include "aboutdialog.h"
#include "aboutdialog.moc"

#include <kapp.h>
#include <kfm.h>

#include <misc.h>
#include <version.h>

#include "icons/logo.xpm"

AboutDialog::AboutDialog(QWidget *parent,const char *name) :
	QDialog(parent,name,true)
{
	setCaption(name);
	
	QString str = PROGNAME " V" VERSION " (c) 1998, 1999, 2000 Markus Weber, Tobias Wollgam\n\n";
	str += QString(i18n("All sources underlay the GNU Public Licence. (read doc/COPYING)")) + "\n";
	str += QString(i18n("Commercialy use is prohibited!")) + "\n\n";
	str += QString(i18n("Please send all questions, comments and bugreports to:")) + "   k4de@gmx.de\n\n";
		
	str += "K4DE-homepage: http://www.k4de.de/\n";
	
	logo = new QLabel(this);
	logo->setPixmap(QPixmap((const char**)logo_xpm));
	
	label = new QLabel(this);
	label->setText(str);

	ok = new QPushButton(this);
	ok->setText(i18n("OK"));
	ok->setAutoDefault(true);

	home = new QPushButton(this);
	home->setText(i18n("Home-Page"));

	mail = new QPushButton(this);
	mail->setText(i18n("Mail"));

	connect(ok,SIGNAL(clicked()),this,SLOT(accept()));
	connect(home,SIGNAL(clicked()),this,SLOT(homePressed()));
	connect(mail,SIGNAL(clicked()),this,SLOT(mailPressed()));
	
	layout();
}

AboutDialog::~AboutDialog()
{
}

void	AboutDialog::okPressed()
{
}

void	AboutDialog::homePressed()
{
	KFM	kfm;
	
	kfm.openURL("http://www.k4de.de/index.html");
}

void	AboutDialog::mailPressed()
{
	KFM	kfm;
	
	kfm.openURL("mailto:k4de@gmx.de");
}

void	AboutDialog::paintEvent(QPaintEvent *)
{
	layout();
}

void	AboutDialog::layout()
{
	int	x,y,w,h,h2,wmax,hmax;

	h2 = MAX(logo->sizeHint().height(),label->sizeHint().height());
	
	x = 5;
	y = 5;
	w = logo->sizeHint().width();
	h = h2;
	
	logo->setGeometry(x,y,w,h);
	
	
	x += w + 10;
	y = 5;

	w = label->sizeHint().width();
	h = h2;
	
	label->setGeometry(x,y,w,h);	
	
	
	wmax = x + 5 + w;
	hmax = 5 + h2;
	
	
	x = 5;
	y += h2 + 5;
	
	w = MAX(MAX(ok->sizeHint().width(),home->sizeHint().width()),mail->sizeHint().width());
	h = 25;

	home->setGeometry(x,y,w,h);
	
		
	x += 5 + w;
	
	mail->setGeometry(x,y,w,h);
	
		
	x = wmax - 5 - w;
	
	ok->setGeometry(x,y,w,h);
	
	
	hmax += 5 + 25 + 5;
		
	if(wmax != width() || hmax != height())
		resize(wmax,hmax);
}


