/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** recursivtree.cpp
*/
#include "recursivtree.h"
#include "recursivtree.moc"

#include "../misc/preferences.h"

#include <stdio.h>
#include <kapp.h>
#include <qimage.h>
#include <qcolor.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qprogressdialog.h>

#include "../misc/preferences.h"

RecursivTreeDialog::RecursivTreeDialog(base *bp,QWidget *pw) :
	QDialog(pw,"Recursive",TRUE)
{
	
	parent = bp;
	
	lex = new QLabel(this);
	lex->setText(i18n("Example:"));
	
	cex = new QComboBox(true,this);
	initExamples();
	
	del = new QPushButton(this);
	del->setText(i18n("Delete"));
	
	save = new QPushButton(this);
	save->setText(i18n("Save"));
	
	lfn = new QLabel(this);
	lfn->setText(i18n("Function:"));
	
	efn = new QLineEdit(this);
	efn->setText("f()");
	
	ldepth = new QLabel(this);
	ldepth->setText(i18n("Depth:"));
	
	edepth = new QLineEdit(this);
	edepth->setText("6");
	
	lname = new QLabel(this);
	lname->setText(i18n("Name:"));
	
	ename = new QLineEdit(this);
	ename->setText("Tree");
	ename->setEnabled(false);
	
	ok = new QPushButton(this);
	ok->setText(i18n("OK"));
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	
	cancel = new QPushButton(this);
	cancel->setText(i18n("Cancel"));
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));
	
	resize(500,170);
	
	layout();
	
	connect(cex,SIGNAL(activated(int)),this,SLOT(selectedExample(int)));
	connect(save,SIGNAL(clicked()),this,SLOT(savedExample()));
	connect(del,SIGNAL(clicked()),this,SLOT(deletedExample()));
}

RecursivTreeDialog::~RecursivTreeDialog()
{
}

void	RecursivTreeDialog::initExamples()
{
	Preferences	prefs;
	int		i;
	QString		ss;
	
	
	ss = cex->currentText();
	cex->clear();
	for(i = 0;i < prefs.getRecursivTreeNumEntries();i++)
	{
		cex->insertItem(prefs.getRecursivTreeLabel(i));
	}
	if(ss != "")
	{
		for(i = 0;i < cex->count();i++)
		{
			if(cex->text(i) == ss)
			{
				cex->setCurrentItem(i);
				break;
			}
		}
	}
}

void	RecursivTreeDialog::selectedExample(int n)
{
	QString		str;
	Preferences	prefs;
	
	str = prefs.getRecursivTreeFunction(n);
	efn->setText(str);
}

void	RecursivTreeDialog::savedExample()
{
	QString		label,fn;
	Preferences	prefs;
	
	label = cex->currentText();
	fn = efn->text();
	
	prefs.setRecursivTree(label,fn);
	
	prefs.save();
	
	initExamples();
}

void	RecursivTreeDialog::deletedExample()
{
	QString		label;
	Preferences	prefs;
	
	label = cex->currentText();
	
	prefs.deleteRecursivTree(label);
	
	prefs.save();
	
	initExamples();
}

void	RecursivTreeDialog::layout()
{
	int	x,y,w,h,w2,w3,w4;
	
	setCaption(i18n("Recursiv"));
	
	w2 = MAX(lfn->sizeHint().width(),ldepth->sizeHint().width());
	w2 = MAX(w2,lname->sizeHint().width());
	w2 = MAX(w2,lex->sizeHint().width());
	
	w3 = width() - 15 - w2;
	w4 = MAX(del->sizeHint().width(),save->sizeHint().width());
	 	
	x = 5;
	y = 5;
	w = w2;
	h = 25;
	
	lex->setGeometry(x,y,w,h);
	
	x += w + 5;
	w = w3 - w4 * 2 - 10;
	
	cex->setGeometry(x,y,w,h);
	
	x += w + 5;
	w = w4;
	
	del->setGeometry(x,y,w,h);
	
	x += w + 5;
	w = w4;
	
	save->setGeometry(x,y,w,h);
	
	x = 5;
	y += h + 5;
	w = w2;
	
	lfn->setGeometry(x,y,w,h);
	
	x += w + 5;
	w = w3;
	
	efn->setGeometry(x,y,w,h);

	x = 5;
	y += h + 5;
	w = w2;

	ldepth->setGeometry(x,y,w,h);

	x += w + 5;
	w = 80;

	edepth->setGeometry(x,y,w,h);

	x = 5;
	y += h + 5;
	w = w2;

	lname->setGeometry(x,y,w,h);

	x += w + 5;
	w = w3;

	ename->setGeometry(x,y,w,h);

	w2 = MAX(ok->sizeHint().width(),cancel->sizeHint().width());

	x = width() - 10 - 2 * w2;
	y = height() - 30;
	w = w2;
	h = 25;

	ok->setGeometry(x,y,w,h);

	x += w + 5;
	cancel->setGeometry(x,y,w,h);
}

obj	*RecursivTreeDialog::getObject()
{
	obj	*op;
	base	**bp;
	int	i;
	
	if(objptr)
	{
		op = objptr;
	}
	else
	{
		op = new obj(parent,"Recursiv");
	}

	if(op)
	{
		// save extradata to the mesh
		QString		qstr;
		QImage		qi;
		Preferences	prefs;
			
		fn = efn->text();
       		if(op->setData("Recursiv","fn",fn) >= 0)
       			printf("xtradata fn ok!\n");
       			
      		qstr = edepth->text();
       		d = qstr.toInt();
       		if(op->setData("Recursiv","depth",d) >= 0)
			printf("xtradata depth ok!\n");
			
      		name = ename->text();
		
		// now do something with the obj
		//op->clear();
		op->getChildren(&bp);
		for(i = 0;bp[i] != 0;i++)
			delete bp[i];
		delete bp;
		
#ifdef DEBUG
		printf("count\n");
#endif
		countObjects();
#ifdef DEBUG
		printf("create\n");
#endif
		createObject();
#ifdef DEBUG
		printf("ready\n");
#endif
	}
		
		
	return op;
}

void	RecursivTreeDialog::setObject(obj *op)
{
	if(op)
	{
		objptr = op;
		if(op->hasDataCollection("Recursiv") >= 0)
		{
			const char	*txt;
			
			objptr = op;
			
			// Fill the dialog
			if(op->getData("Recursiv","fn",txt) >= 0)
			{
				fn = txt;
				efn->setText(fn);
	       			printf("xtradata fn ok!\n");
			}
			if(op->getData("Recursiv","depth",d) >= 0)
			{
				QString		qstr;
				
				qstr.setNum(d);
				edepth->setText(qstr);
				printf("xtradata depth ok!\n");
			}
			ename->setText(op->getName());
		}
	}
	else
	{
		objptr = 0;
	}
}

void	RecursivTreeDialog::paintEvent(QPaintEvent*)
{
	layout();
}

int	RecursivTreeDialog::parseObjects(const char *formatedin,Vector3 location,Vector3 rotation,obj *object,paralist_t *plist,int index)
{
	Vector3		vloc,vrot,v;
	Vector3		vy(1,0,0);
	char		**terms;
	char		*formated;
	char		*term;
	char		*func,*subterm;
	int		t;
	ntuple_t	*r = 0;
	transform	*dptr;
	obj		*subobject = 0;
	double		d;
	char		name[40];
	paralist_t	usrplist = {0,0};
	QString		str;
	

	objcounter++;
	str.sprintf("%i %s %i ",objcounter,i18n("of"),numobj);
	str += i18n("objects created");
	emit report(str);

	
	copy_paralist(plist,&usrplist);

	d = get_param(&usrplist,"depth");
	
	if(d < 0.01)
	{
		kill_paralist(&usrplist);
		return 0;
	}
		
	sprintf(name,"%s.%i",object->getName(),index);

	index = 0;

	vloc = location;
	vrot = rotation;


//	subobject = new obj(object,name);
	subobject = new obj(object);
	
	if(!subobject)
	{
		kill_paralist(&usrplist);
		return -2;
	}

	object = subobject;
	object->setName(name);
	object->rotate(vrot);
	object->translate(vloc);
	vloc = Vector3(0,0,0);
	vrot = Vector3(0,0,0);

	formated = strdup(formatedin);
	terms = get_simple_terms(formated);

	term = terms[0];
	t = 1;

	while(term)
	{
		func = get_function_name(term);
		subterm = get_subterm();
		if(func)
		{
			if(strcmp(func,"set") == 0)
			{
				char		**subterms;

				subterms = get_simple_terms(subterm);
				r = eval_term(subterms[1],&usrplist);
				if(r && r->tuple)
					set_param(&usrplist,subterms[0],r->tuple[0]);
				free(subterms);
			}
			else
			{
				r = eval_term(subterm,&usrplist);
				if(strcmp(func,"go") == 0)
				{
					if(r && r->ntuple == 1)
					{
						Vector4		v4;
						Matrix44	m;
					
						v4 = vy * r->tuple[0];
					
						m.rotateVector(Vector3(0,vrot[1],-vrot[2]));
					
						v = v4 * m;
					
						vloc += v;
					}
					else if(r && r->ntuple >= 3)
					{
						Vector4		v4;
						Matrix44	m;
					
						v4 = Vector3(r->tuple[0],r->tuple[1],r->tuple[2]);
					
						m.rotateVector(Vector3(0,vrot[1],-vrot[2]));
					
						v = v4 * m;
					
						vloc += v;
					}
				}
				else if(strcmp(func,"cyl") == 0)
				{
       					Vector3		vs(1,1,1);
       					Vector3		vr;
       					Vector3		vt;
					if(r && r->ntuple >= 3)
					{
						vs = Vector3(r->tuple[0],r->tuple[1],r->tuple[2]);
					}
					if(r && r->ntuple >= 6)
					{
						vr = Vector3(r->tuple[3],r->tuple[4],r->tuple[5]);
					}
					if(r && r->ntuple >= 9)
					{
						vt = Vector3(r->tuple[6],r->tuple[7],r->tuple[8]);
					}
						
//     					dptr = new cylinder(object,name);
     					dptr = new cylinder(object);
     					dptr->setName(name);
       					
       					dptr->translate(vt);
       					dptr->translate(vloc);
       					//dptr->translate(0,vs[1] / 2,0);
       					dptr->rotate(vr);
       					dptr->rotate(vrot[0],vrot[1],vrot[2]);
       					dptr->scale(vs);
				}
				else if(strcmp(func,"box") == 0)
				{
       					Vector3		vs(1,1,1);
       					Vector3		vr;
       					Vector3		vt;
					if(r && r->ntuple >= 3)
					{
						vs = Vector3(r->tuple[0],r->tuple[1],r->tuple[2]);
					}
					if(r && r->ntuple >= 6)
					{
						vr = Vector3(r->tuple[3],r->tuple[4],r->tuple[5]);
					}
					if(r && r->ntuple >= 9)
					{
						vt = Vector3(r->tuple[6],r->tuple[7],r->tuple[8]);
					}
						
       					dptr = new box(object);
     					dptr->setName(name);
       					
       					dptr->translate(vt);
       					dptr->translate(vloc);
       					//dptr->translate(0,vs[1] / 2,0);
       					dptr->rotate(vr);
       					dptr->rotate(vrot);
       					dptr->scale(vs);
				}
				else if(strcmp(func,"sphere") == 0)
				{
       					Vector3		vs(1,1,1);
       					Vector3		vr;
       					Vector3		vt;
					if(r && r->ntuple >= 3)
					{
						vs = Vector3(r->tuple[0],r->tuple[1],r->tuple[2]);
					}
					if(r && r->ntuple >= 6)
					{
						vr = Vector3(r->tuple[3],r->tuple[4],r->tuple[5]);
					}
					if(r && r->ntuple >= 9)
					{
						vt = Vector3(r->tuple[6],r->tuple[7],r->tuple[8]);
					}
						
       					dptr = new sphere(object);
      					dptr->setName(name);
      					
      					dptr->translate(vt);
       					dptr->translate(vloc);
       					//dptr->translate(0,vs[1] / 2,0);
       					dptr->rotate(vr);
       					dptr->rotate(vrot);
       					dptr->scale(vs);
				}
				else if(strcmp(func,"cone") == 0)
				{
       					Vector3		vs(1,1,1);
       					Vector3		vr;
       					Vector3		vt;
       					double		rad = 1;
					
					if(r && r->ntuple >= 3)
					{
						vs = Vector3(r->tuple[0],r->tuple[1],r->tuple[2]);
					}
					if(r && r->ntuple >= 6)
					{
						vr = Vector3(r->tuple[3],r->tuple[4],r->tuple[5]);
					}
					if(r && r->ntuple >= 9)
					{
						vt = Vector3(r->tuple[6],r->tuple[7],r->tuple[8]);
					}
					if(r && r->ntuple >= 10)
					{
						rad = r->tuple[9];
					}
						
					dptr = new cone(object);
					dptr->setName(name);
					((cone*)dptr)->setCapRadius(rad);
					
					dptr->translate(vt);
					dptr->translate(vloc);
					//dptr->translate(0,vs[1] / 2,0);
					dptr->rotate(vr);
					dptr->rotate(vrot);
					dptr->scale(vs);
				}
				else if(strcmp(func,"object") == 0)
				{
					Vector3		vs(1,1,1);
					Vector3		vr;
					Vector3		vt;
					double		rad = 1;
					int		type = 0;
					
					if(r && r->ntuple >= 1)
					{
						type = (int)r->tuple[0];
					}
					if(r && r->ntuple >= 4)
					{
						vs = Vector3(r->tuple[1],r->tuple[2],r->tuple[3]);
					}
					if(r && r->ntuple >= 7)
					{
						vr = Vector3(r->tuple[4],r->tuple[5],r->tuple[6]);
					}
					if(r && r->ntuple >= 10)
					{
						vt = Vector3(r->tuple[7],r->tuple[8],r->tuple[9]);
					}
					if(r && r->ntuple >= 11)
					{
						rad = r->tuple[10];
					}
						
					switch(type)
					{
						case 0: // none
						break;
						case 1: // sphere
							dptr = new sphere(object);
							dptr->setName(name);
							
							dptr->translate(vt);
							dptr->translate(vloc);
							//dptr->translate(0,vs[1] / 2,0);
							dptr->rotate(vr);
							dptr->rotate(vrot);
							dptr->scale(vs);
						break;
						case 2: // cylinder
							dptr = new cylinder(object);
							dptr->setName(name);
							
							dptr->translate(vt);
							dptr->translate(vloc);
							//dptr->translate(0,vs[1] / 2,0);
							dptr->rotate(vr);
							dptr->rotate(vrot[0],vrot[1],vrot[2]);
							dptr->scale(vs);
						break;
						case 3: // cone
	      						dptr = new cone(object);
							dptr->setName(name);
							((cone*)dptr)->setCapRadius(rad);
							
							dptr->translate(vt);
   							dptr->translate(vloc);
   							//dptr->translate(0,vs[1] / 2,0);
   							dptr->rotate(vr);
   							dptr->rotate(vrot);
   							dptr->scale(vs);
						break;
						case 4: // box
   							dptr = new box(object,name);
 							dptr->setName(name);

   							dptr->translate(vt);
   							dptr->translate(vloc);
   							//dptr->translate(0,vs[1] / 2,0);
   							dptr->rotate(vr);
   							dptr->rotate(vrot);
   							dptr->scale(vs);
						break;
						default: // none
						break;
					}
				}
				else if(strcmp(func,"turn") == 0)
				{
					if(r && r->ntuple >= 3)
					{
						vrot[0] += r->tuple[0];
						vrot[1] += r->tuple[1];
						vrot[2] += r->tuple[2];
					}
				}
				else if(strcmp(func,"f") == 0)
				{
					d = get_param(&usrplist,"depth");
					if(d > 1)
					{
						set_param(&usrplist,"depth",d - 1);
						set_param(&usrplist,"d",d - 1);
						parseObjects(formatedin,vloc,vrot,object,&usrplist,index);
						set_param(&usrplist,"depth",d);
						set_param(&usrplist,"d",d);
						index++;
					}
				}
			}
			if(r)
			{
				if(r->tuple)
				{
					free(r->tuple);
				}
				free(r);
				r = 0;
			}
			free(func);
		}
		term = terms[t];
		t++;
	}
	free(formated);
	free(terms);
	kill_paralist(&usrplist);

	return 0;
}

int	RecursivTreeDialog::countObjects(const char *unformatedin,paralist_t *plist,int index)
{
	char		**terms;
	char		*formated,*unformated;
	char		*term;
	char		*func,*subterm;
	int		t;
	ntuple_t	*r = 0;
	double		d;
	paralist_t	usrplist = {0,0};

	objcounter++;
	
	copy_paralist(plist,&usrplist);

	d = get_param(&usrplist,"depth");
	if(d < 0.01)
	{
		kill_paralist(&usrplist);
		return 0;
	}

	index = 0;

	unformated = strdup(unformatedin);
	if(!unformated)
	{
		return 1;
	}
	formated = format_term(unformated);
	if(!formated)
	{
		free(unformated);
		return 2;
	}

	formated = strdup(formated);
	terms = get_simple_terms(formated);

	term = terms[0];
	t = 1;

	while(term)
	{
		func = get_function_name(term);
		subterm = get_subterm();
		if(func)
		{
			if(strcmp(func,"set") == 0)
			{
				char		**subterms;

				subterms = get_simple_terms(subterm);
				r = eval_term(subterms[1],&usrplist);
				if(r && r->tuple) set_param(&usrplist,subterms[0],r->tuple[0]);
				free(subterms);
			}
			else
			{
				if(strcmp(func,"f") == 0)
				{
					d = get_param(&usrplist,"depth");
					if(d > 1)
					{
						set_param(&usrplist,"depth",d - 1);
						set_param(&usrplist,"d",d - 1);
						countObjects(unformated,&usrplist,index);
						set_param(&usrplist,"depth",d);
						set_param(&usrplist,"d",d);
						index++;
					}
				}
			}
			if(r)
			{
				if(r->tuple)
				{
					free(r->tuple);
				}
				free(r);
				r = 0;
			}
			free(func);
		}
		term = terms[t];
		t++;
	}
	free(terms);
	free(formated);
	free(unformated);
	kill_paralist(&usrplist);

	return 0;
}

int	RecursivTreeDialog::createObject()
{
	QString		kochterm;
	paralist_t	plist = {0,0};
	Vector3		v0(0,0,0);
	obj		*object;

	if(d < 1)
		return 0;


	kochterm = "(" + fn + ")";

	set_param(&plist,"maindepth",d);
	set_param(&plist,"md",d);
	set_param(&plist,"depth",d);
	set_param(&plist,"d",d);
	set_param(&plist,"PI",PI);
	set_param(&plist,"ELSE",1);

	object = objptr;

	numobj = objcounter;
	objcounter = 0;
	
	if(object)
	{
		char	*unformated,*formated;
		
		unformated = strdup(kochterm);
		formated = format_term(unformated);

		parseObjects(formated,v0,v0,object,&plist,0);
	
		free(unformated);
	}

	kill_paralist(&plist);
	
	return 0;
}

int	RecursivTreeDialog::countObjects()
{
	QString		kochterm;
	paralist_t	plist = {0,0};

	objcounter = 0;
	
	if(d < 1)
		return 0;

	kochterm = "(" + fn + ")";

	set_param(&plist,"depth",d);
	set_param(&plist,"d",d);
	set_param(&plist,"PI",PI);
	set_param(&plist,"ELSE",1);

	if(objptr)
	{
		countObjects(kochterm,&plist,0);
	}

	kill_paralist(&plist);

	return 0;
}

