/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** recursivtree.h
*/
#ifndef __RECURSIVTREE_H__
#define __RECURSIVTREE_H__

#include <objects.h>
#include <evaluate.h>

#include <qstring.h>
#include <qdialog.h>


class QLabel;
class QLineEdit;
class QPushButton;
class QComboBox;
class QProgressDialog;

class RecursivTreeDialog : public QDialog
{
Q_OBJECT
protected:
	QString		fn,name;
	int		d;
        obj		*objptr;
        base		*parent;

        QLabel		*lex;
        QComboBox	*cex;
	QPushButton	*del,*save;
        QLabel		*lfn;
        QLineEdit	*efn;
        QLabel		*ldepth;
        QLineEdit	*edepth;
        QLabel		*lname;
        QLineEdit	*ename;

	QPushButton	*ok,*cancel;
	
	int		objcounter,numobj;
	
public:
	RecursivTreeDialog(base *pbase=0,QWidget* pw=0);
	~RecursivTreeDialog();

	obj		*getObject();
	void		setObject(obj *);
	
private:
	void		layout();
	int		parseObjects(const char *unformated,Vector3 location,Vector3 rotation,obj *object,paralist_t *plist,int index);
	int		createObject();
	int		countObjects(const char *unformated,paralist_t *plist,int index);
	int		countObjects();
	
private slots:
	void		paintEvent(QPaintEvent*);
	void		selectedExample(int);
	void		savedExample();
	void		deletedExample();
	void		initExamples();

signals:
	void		report(QString);
};


#endif


