/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** comm.cpp
*/
#include "comm.h"
#include "comm.moc"

#include <stdio.h>
#include <stdlib.h>

Comm::Comm() :
	QObject(), com("")
{
	stackptr = -1;
}

Comm::~Comm()
{
	while(stackptr >= 0)
	{
		close(stack[stackptr][0]);
		close(stack[stackptr][1]);
		close(stack[stackptr][2]);
		close(stack[stackptr][3]);
		stack[stackptr][0] = -1;
		stack[stackptr][1] = -1;
		stack[stackptr][2] = -1;
		stack[stackptr][3] = -1;
		stackptr--;
	}
}

int	Comm::start(char *sc,int time,int start,int end,int stepsize)
{
	char	sr[8],sw[8],st[12],ss[12],se[12],sss[12];

	stackptr++;
	
	pipe(stack[stackptr]);
	pipe(stack[stackptr] + 2);
	
	sprintf(sr,"%i",stack[stackptr][2]);
	sprintf(sw,"%i",stack[stackptr][1]);
	sprintf(st,"%i",time);
	sprintf(ss,"%i",start);
	sprintf(se,"%i",end);
	sprintf(sss,"%i",stepsize);


	memset(buffer,0,sizeof(buffer));

	switch((stack[stackptr][4] = fork()))
	{
		case 0: // child process
			execlp(sc,sc,sr,sw,st,ss,se,sss,(char*)0);
			printf("Error execlp\n");
			exit(3);
		case -1: // error fork
			printf("Error fork\n");
			stack[stackptr][4] = 0;

			return -1;
		break;
		default:
			// den lesekanal nonblocking setzen
			fcntl(stack[stackptr][0],F_SETFL,O_NONBLOCK);
			fcntl(stack[stackptr][3],F_SETFL,O_NONBLOCK);
	}

	return 0;
}

int	Comm::stop()
{
	if(stack[stackptr][4] > 0)
	{
		int	i,status;

		kill(stack[stackptr][4],9);
		close(stack[stackptr][0]);
		close(stack[stackptr][1]);
		close(stack[stackptr][2]);
		close(stack[stackptr][3]);
		stack[stackptr][0] = -1;
		stack[stackptr][1] = -1;
		stack[stackptr][2] = -1;
		stack[stackptr][3] = -1;
		
#ifdef DEBUG
		printf("Wait for pid %i\n",stack[stackptr][4]);
#endif
		for(i = 0;i < 10000 && waitpid(stack[stackptr][4],&status,WNOHANG) < 1;i++);
		
		stackptr--;
		
		if(i == 10000 || !WIFEXITED(status))
			return -1;
	}
	
	return 0;
}

int	Comm::clear()
{
	if(stack[stackptr][0] >= 0)
	{
		close(stack[stackptr][0]);
		stack[stackptr][0] = -1;
	}
	if(stack[stackptr][1] >= 0)
	{
		close(stack[stackptr][1]);
		stack[stackptr][1] = -1;
	}
	if(stack[stackptr][2] >= 0)
	{
		close(stack[stackptr][2]);
		stack[stackptr][2] = -1;
	}
	if(stack[stackptr][3] >= 0)
	{
		close(stack[stackptr][3]);
		stack[stackptr][3] = -1;
	}
	stackptr--;
	
	return 0;
}

int	Comm::read(char *s)
{
	int	i = 0;

	char	tbuffer[256];

	s[0] = 0;

	i = ::read(stack[stackptr][0],tbuffer,sizeof(tbuffer) - 1);
	if(i > 0)
	{
		tbuffer[i] = 0;
		strcat(buffer,tbuffer);
	}

	if(strchr(buffer,'\n') && (i = strchr(buffer,'\n') - buffer) < (int)sizeof(buffer))
	{
		strncpy(tbuffer,buffer,i + 1);
		tbuffer[i + 1] = 0;
		memmove(buffer,buffer + i + 1,strlen(buffer) - i);
		memset(buffer + strlen(buffer),0,sizeof(buffer) - strlen(buffer));

		strcpy(s,tbuffer);

		return i;
	}

	return 0;
}

int	Comm::write(char *s)
{
	return ::write(stack[stackptr][3],s,strlen(s));
}

int	Comm::isRunning()
{
	int	status;

	return (waitpid(stack[stackptr][4],&status,WNOHANG) == 0);
}


