/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** textureview.h
*/
#ifndef __PREVIEWVIEW_H__
#define __PREVIEWVIEW_H__

class PreviewWidget;
class QPushButton;
class QCheckBox;
class textureBase;

#include <qwidget.h>

class	 PreviewView: public  QWidget
{
Q_OBJECT

protected:
	PreviewWidget		*preview;
	textureBase		*actual;

	QPushButton		*zoomIn,*zoomOut,*zoom,*updateBt;
	QCheckBox		*hollow,*quick,*autoUpdate;

	bool			overrideAutoUpdate;

public:
	PreviewView(QWidget *p, const char *name);
	~PreviewView();

	void paintEvent(QPaintEvent *);

public slots:
	void updateContent(textureBase *);
	void updateContent();
	void updateClicked();
};

#endif
