/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** previewwidget.cpp
*/
#include "previewwidget.h"
#include "previewwidget.moc"

#include "../misc/preferences.h"

#include <qpainter.h>
#include <qpixmap.h>

PreviewWidget::PreviewWidget(QWidget *p,char *n) :
	QFrame(p,n)
{
	setFrameStyle( Box | Sunken );
        setLineWidth(1);

	qpm = new QPixmap(width() - 4,height() - 4);
	qp = new QPainter(qpm);
	
	quality = 9;
	hollow = false;
	ppmfp = 0;
	tcounter = -1;
	lastrendered = 0;
}

PreviewWidget::~PreviewWidget()
{
	qp->end();
	delete qp;
	delete qpm;
}

void 	PreviewWidget::zoomIn()
{
}

void	PreviewWidget::zoomOut()
{
}

void	PreviewWidget::originalSize()
{
}

void	PreviewWidget::setHollow(bool h)
{
	hollow = h;
	render(lastrendered);
}

void	PreviewWidget::setQuick(bool h)
{
	if(h)
		quality = 1;
	else
		quality = 9;
	render(lastrendered);
}

void	PreviewWidget::render(texture *t)
{
	char		str[16];
	QString		qstr;
	Preferences	prefs;
	FILE		*fp;

	if(t == 0)
		return;
		
	// now wait a quarter second
	if(tcounter != -1 && tcounter < 5)
		return;
		
	// stop all the timer of this widget
	killTimers();
	proc.kill();
	if(ppmfp)
		fclose(ppmfp);
	ppmfp = 0;
	flush();

	tmpdir = prefs.getTempPath();
	tmpname.sprintf("tmp%i",rand());
	
	qstr = prefs.getPath("~/.k4de/texture/.template") + "/texture.pov";
//	printf("%s\n",(const char*)qstr);
	if((fp = fopen((const char*)qstr,"w")) == 0)
		return;
	if(hollow == true)
		fprintf(fp,"hollow on");
	t->exportPOV(fp,0,4,0);
	fclose(fp);

	proc.clearArguments();

	proc << prefs.getRenderProgram();
	sprintf(str,"+W%i",width());
	proc << str;
	sprintf(str,"+H%i",height());
	proc << str;
//	proc << "-GA";
	qstr = "+L" + prefs.getPath("~/.k4de/texture/.template");
//	printf("%s\n",(const char*)qstr);
	proc << qstr;
	qstr = "+O" + tmpdir + "/" + tmpname + ".ppm";
//	printf("%s\n",(const char*)qstr);
	proc << qstr;
	qstr = "+I" + prefs.getPath("~/.k4de/texture/.template") + "/texturebody.pov";
//	printf("%s\n",(const char*)qstr);
	proc << qstr << "+FP";
	qstr.sprintf("+Q%i",quality);
	proc << qstr;
	
	proc.start(KProcess::DontCare,KProcess::Stdout);

	x = y = 0;

	tcounter = 0;
	ppmfp = 0;
	lc = 0;

	startTimer(150);
}

void		PreviewWidget::stop()
{
	QString		qstr;
	
	
	if(!ppmfp)
		return;
		
	killTimers();
	proc.kill();
	if(ppmfp)
		fclose(ppmfp);
	ppmfp = 0;
	flush();
	
	qstr = "rm -f " + tmpdir + "/" + tmpname + ".ppm";
	system(qstr);
	
	tcounter = -1;
}

void		PreviewWidget::timerEvent(QTimerEvent*)
{
	QString		tmpstr,qstr;

	if(!proc.isRunning())
	{
		if(proc.normalExit())
		{
#ifdef DEBUG
			printf("Renderer exitstatus:%i\n",proc.exitStatus());
#endif
		}
		else
		{
#ifdef DEBUG
			printf("Renderer killed by foreign process!\n");
#endif
		}
		killTimers();
		proc.kill();
		tcounter = -1;

		if(ppmfp != 0)
			readImage();
		// Attention! readImage could close the file
		if(ppmfp != 0)
		{
			fclose(ppmfp);
			ppmfp = 0;
		}
		flush();
			
		return;	
	}
	if(ppmfp == 0)
	{

		tcounter++;
		// 800 * 150ms = 120000ms = 120sec timeout
		if(tcounter > 800)
		{
			killTimers();
			proc.kill();

			return;
		}
		
		ppmfp = fopen(tmpdir + "/" + tmpname + ".ppm","rb");
		
		if(ppmfp == 0)
			return;
		fseek(ppmfp,0,SEEK_SET);
	}
	readImage();
}

void		PreviewWidget::readImage()
{
	unsigned char	buffer[3 * 1024];
	int		i,t,r,g,b,p;
	QString		tmpstr,qstr;
	
	if(lc < 3)
	{
		p = ftell(ppmfp);
		fseek(ppmfp,0,SEEK_END);
		if(ftell(ppmfp) <= p)
		{
			fseek(ppmfp,p,SEEK_SET);
			return;
		}
		fseek(ppmfp,p,SEEK_SET);
		
		do
		{
			fread(buffer,1,1,ppmfp);
		}
		while(buffer[0] != '\n');
		lc++;
		return;
	}

	p = ftell(ppmfp);
	fseek(ppmfp,0,SEEK_END);
	if(ftell(ppmfp) <= p)
	{
		fseek(ppmfp,p,SEEK_SET);
		return;
	}
	fseek(ppmfp,p,SEEK_SET);
	
	while((i = fread(buffer,3,1024,ppmfp)) > 0)
	{

		for(t = 0;t < i;t++)
		{
			r = buffer[t * 3];
			g = buffer[t * 3 + 1];
			b = buffer[t * 3 + 2];
			qp->setPen(QColor(r,g,b));
			qp->drawPoint(x++,y);
			if(x >= width())
			{
				x = 0;
				y++;
				if(y >= height())
				{
					stop();
					
					return;
				}
			}
		}
	}
	
	flush();
}



void		PreviewWidget::paintEvent(QPaintEvent *pe)
{
	flush();
	
	QFrame::paintEvent(pe);
}

void		PreviewWidget::resizeEvent(QResizeEvent *re)
{
	qp->end();
	qpm->resize(width() - 4,height() - 4);
	qp->begin(qpm);

	qp->eraseRect(0,0,width() - 4,height() - 4);
	
	render(lastrendered);
	
	QFrame::resizeEvent(re);
}

void		PreviewWidget::flush()
{
	QPainter	paint(this);

	qp->end();
	paint.drawPixmap(2,2,*qpm);
	qp->begin(qpm);
}
