/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*

*/

#include "repeatwarpwidget.moc"
#include "repeatwarpwidget.h"

#include <kapp.h>

repeatWarpWidget::repeatWarpWidget(QWidget *parent,repeatWarp *p) :
	TextureWidgetBase(parent,"repeatWarpWidget")
{
	wa=p;	
	
	tbasew=new TextureBaseWidget(this,wa );
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	flip=new VectorWidget(this,i18n("Flip"));
	flip->setVector(wa->getFlip());
	connect(flip,SIGNAL(changed()),this,SIGNAL(valueChanged()) );	

	offset=new VectorWidget(this,i18n("Offset"));
	offset->setVector(wa->getOffset());
	connect(offset,SIGNAL(changed()),this,SIGNAL(valueChanged()) );	

	dir_label=new QLabel(i18n("Direction:"));

	dir=new QComboBox(this);
	dir->insertItem(i18n("off"),0);
	dir->insertItem(i18n("X"),1);
	dir->insertItem(i18n("Y"),2);
	dir->insertItem(i18n("Z"),3);
	dir->setCurrentItem(wa->getDirection() );
	connect(offset,SIGNAL(activated(int)),this,SIGNAL(valueChanged()) );	

	r_dir=new SpinBox(this,i18n("Length"),wa->getDirectionLength() );
	connect(r_dir,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );	

	paintEvent(NULL);
}


repeatWarpWidget::~repeatWarpWidget()
{
	if (flip) delete flip;
	if (offset) delete offset;
	if (dir_label) delete dir_label;
	if (dir) delete dir;
	if (r_dir) delete r_dir;
	if (tbasew) delete tbasew;
}

void repeatWarpWidget::getValue()
{
	wa->setFlip(flip->getVector());
	wa->setOffset(offset->getVector());
	wa->setDirection(dir->currentItem() );
	wa->setDirectionLength(r_dir->getValue());
	tbasew->getTextureBase();
}

QSize repeatWarpWidget::sizeHint() const
{
	return qs;
}

void repeatWarpWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0,w1=0,w2=0,h2=0,w3=0,w4=0;


	tbasew->setGeometry(10,10,w,h);
	y+=15+h;
	w+=10;

	w1=flip->sizeHint().width();
	w2=offset->sizeHint().width();
	h2=offset->sizeHint().height();	
	offset->setGeometry(10,y,w2,h2);
	flip->setGeometry(15+w2,y,w1,h2);

	w=MAX(w,w2+w1+15);
	y+=h2+5;


	w2=dir_label->sizeHint().width();
	h2=r_dir->sizeHint().height();	
	dir_label->setGeometry(10,y,w2,h2);

	w3=dir->sizeHint().width();
	dir->setGeometry(15+w2,y,w3,h2);

	w4=r_dir->sizeHint().width();
	r_dir->setGeometry(20+w2+w3,y,w4,h2);

	w=MAX(w,20+w2+w3+w4);
	y+=h2+5;


	qs.setWidth(w+5);
	qs.setHeight(y+5);
	if (qp) QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

repeatWarpDialog::repeatWarpDialog(QWidget *parent,repeatWarp *p) :
	QDialog(parent,"repeatWarpDialog",true)
{
	setCaption(i18n("repeatWarp"));

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new repeatWarpWidget(this,p);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}

repeatWarpDialog::~repeatWarpDialog()
{
	if (pw) delete pw;
	if (ok) delete ok;
	if (cancel) delete cancel;
}


void repeatWarpDialog::cancelPressed()
{
	QDialog::done(0);
}

void repeatWarpDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void repeatWarpDialog::paintEvent(QPaintEvent* qp)
{
 	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	h+=h1+5;

	pw->setGeometry(0,0,w,h);
	setMinimumSize(w,h);
	setMaximumSize(w,h);
	if (qp) QDialog::paintEvent(qp);
}
