/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** surfacemapdialog.cpp
*/
#include "surfacemapdialog.h"
#include "surfacemapdialog.moc"


#include "patternmodifierdialog.h"

#include <kapp.h>

#include <qtooltip.h>

SurfaceMapWidget::SurfaceMapWidget(QWidget *parent,surfaceMap *c) :
	TextureWidgetBase(parent,"SurfaceMapWidget")
{
	co=c;

	tbasew=new TextureBaseWidget(this,co);
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	pmd=new PatternModifierWidget(this,co->getMapModifier(),0 );
	connect(pmd,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );
	paintEvent(NULL);
}

SurfaceMapWidget::~SurfaceMapWidget()
{
	if (tbasew) delete tbasew;
	if (pmd) delete pmd;
}

void SurfaceMapWidget::getValue()
{
	if (pmd) pmd->getPatternModifier();
	if (tbasew) tbasew->getTextureBase();
}

QSize SurfaceMapWidget::sizeHint() const
{
	return qs;
}

void SurfaceMapWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0,w1=0,h1=0;

	tbasew->setGeometry(10,10,w,h);
	y+=h+15;


	w1=pmd->sizeHint().width();
	h1=pmd->sizeHint().height();
        pmd->setGeometry(10,y,w1,h1);

	y+=h1+10;
	w=MAX(w,w1);	

	qs.setWidth(w+5);
	qs.setHeight(y+5);
	if (qp) QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

SurfaceMapDialog::SurfaceMapDialog(QWidget *parent,surfaceMap *co) :
	QDialog(parent,"SurfaceMapDialog",true)
{
	setCaption(i18n("SurfaceMap"));

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);
	pw=new SurfaceMapWidget(this,co);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}

SurfaceMapDialog::~SurfaceMapDialog()
{
	if (pw) delete pw;
	if (ok) delete ok;
	if (cancel) delete cancel;
}


void SurfaceMapDialog::cancelPressed()
{
	QDialog::done(0);
}

void SurfaceMapDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void SurfaceMapDialog::paintEvent(QPaintEvent* qp)
{
 	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	pw->setGeometry(0,0,w,h);
	setMinimumSize(w,h);
	setMaximumSize(w,h);
	if (qp) QDialog::paintEvent(qp);
}
