/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** mainwin.cpp
*/


#include <version.h>

#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmsgbox.h>
#include <kstatusbar.h>

#include "texturetoolbar.h"
#include "texturetoolbar.moc"
#include "textureattributeview.h"
#include <misc.h>

#include "icons/toolbar/inserttexture.xpm"
#include "icons/toolbar/newtexture.xpm"
#include "icons/toolbar/newtexturefolder.xpm"
#include "icons/toolbar/newtexturewindow.xpm"
#include "icons/toolbar/savetexturelib.xpm"
#include "icons/toolbar/newpigment.xpm"
#include "icons/toolbar/newnormal.xpm"
#include "icons/toolbar/newfinish.xpm"
#include "icons/toolbar/newinterior.xpm"


TextureToolBar::TextureToolBar(QWidget *p, TextureView *tw)
	: KToolBar(p)
{

	tview=tw;
	connect(tw,SIGNAL(changedLibrary(TextureLibrary *)),this,SLOT(setLibrary(TextureLibrary*)) );
	tlib=tview->getTextureLibrary();
	selTexture=tview->getTextureLibrary();

	//MSurface=new QPopupMenu;
	//MSurface->insertItem(i18n("Surface"),60);
	//MSurface->insertSeparator();
	//MSurface->insertItem(i18n("Surfacemap"),61);
	//MSurface->insertItem(i18n("Surfacelist"),62);

	MPigment = new QPopupMenu;
	MPigment->insertItem(i18n("Pigment"),10);
	MPigment->insertSeparator();
	MPigment->insertItem(i18n("Color"),11);
	MPigment->insertItem(i18n("Image"),12);
	MPigment->insertSeparator();
	MPigment->insertItem(i18n("Colormap"),13);
	MPigment->insertItem(i18n("Colorlist"),14);
	MPigment->insertSeparator();
	MPigment->insertItem(i18n("Pigmentmap"),15);
	MPigment->insertItem(i18n("Pigmentlist"),16);

	MNormal = new QPopupMenu;
	MNormal->insertItem(i18n("Normal"),20);
	MNormal->insertSeparator();
	MNormal->insertItem(i18n("Bumpmap"),21);
	MNormal->insertItem(i18n("Slopemap"),22);
	MNormal->insertSeparator();
	MNormal->insertItem(i18n("Normalmap"),23);
	MNormal->insertItem(i18n("Normallist"),24);

	MFinish = new QPopupMenu;
	MFinish->insertItem(i18n("Finish-Parameter"),30);


	MInterior = new QPopupMenu;
	MInterior->insertItem(i18n("Interior"),40);
	//MInterior->insertSeparator();
	//MInterior->insertItem(i18n("Density"),41);

	//MSurface=new QPopupMenu;
	//MSurface->insertItem(i18n("Surface"),80);
	//MSurface->insertItem(i18n("Surfacelist"),81);
	//MSurface->insertItem(i18n("Surfacemap"),82);


	MBook = new QPopupMenu;
	MBook->insertItem(i18n("Insert in Library"),71);
	MBook->insertItem(i18n("Insert here"),72);


	//insertButton(QPixmap((const char**)newtexturewindow_xpm),61,true,i18n("Open new Texture-Library-Window"));
	//insertSeparator();
	//insertButton(QPixmap((const char**)inserttexture_xpm),62,true,i18n("Insert Texture-Library"));
	//insertButton(QPixmap((const char**)savetexturelib_xpm),63,true,i18n("Save Texture-Library"));
	//insertSeparator();
	insertButton(QPixmap((const char**)newtexture_xpm),64,true,i18n("New Material"));
	//insertButton(QPixmap((const char**)newtexturefolder_xpm),65,MBook,i18n("New Material-Folder"));
	insertSeparator();
	insertSeparator();

	//insertButton(QPixmap((const char**)newinterior_xpm),11,MSurface,true,i18n("Edit/New Surfaceobjects"));
       	insertButton(QPixmap((const char**)newpigment_xpm),6,MPigment,true,i18n("Edit/New Pigment/Pigmentobjects") );
	insertButton(QPixmap((const char**)newnormal_xpm),7,MNormal,true,i18n("Edit/New Normal-Element"));
	insertButton(QPixmap((const char**)newfinish_xpm),8,MFinish,true,i18n("Edit/New Finish"));
	insertButton(QPixmap((const char**)newinterior_xpm),9,MInterior,true,i18n("Edit/New Interior"));

	//connect(MSurface,SIGNAL(activated(int)),this,SLOT(sel(int)) );
	connect(MPigment,SIGNAL(activated(int)),this,SLOT(sel(int)) );
	connect(MNormal,SIGNAL(activated(int)),this,SLOT(sel(int)) );
	connect(MFinish,SIGNAL(activated(int)),this,SLOT(sel(int)) );
	connect(MInterior,SIGNAL(activated(int)),this,SLOT(sel(int)) );
	connect(MBook,SIGNAL(activated(int)),this,SLOT(sel(int)) );

	connect(this,SIGNAL(clicked(int)),this,SLOT(sel(int)) );
}

TextureToolBar::~TextureToolBar()
{
	if (MPigment) delete MPigment;
	if (MFinish) delete MFinish;
	if (MInterior) delete MInterior;
	if (MNormal) delete MNormal;
	//if (MSurface) delete MSurface;
}

void TextureToolBar::newTextureSel(textureBase *tb)
{
	selTexture=tb;	
}

void TextureToolBar::setLibrary(TextureLibrary *tl)
{
	selTexture=tl;	
	tlib=tl;
}


void TextureToolBar::sel(int x)
{
textureBase *ttb,*tb=selTexture;

        switch(x) {


		case 10:
			if ( (ttb=tb->getElementByType(PIGMENT))==NULL) {
				pigment *c=new pigment(NULL);
				if ((tb->canAdd(c))) {
					//PigmentDialog *cd=new PigmentDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				} else delete c;
			} else {
				//PigmentDialog *cd=new PigmentDialog(NULL,(pigment *)ttb);
				//cd->exec();
			}
		break;
		case 11:
			if ( (ttb=tb->getElementByType(COLOR))==NULL) {
				color *c=new color(NULL);
				if (tb->canAdd(c)) {
					//ColorDialog *cd=new ColorDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				} else delete c;
			} else {
				//ColorDialog *cd=new ColorDialog(NULL,(color *)ttb);
				//cd->exec();
			}
		break;
		case 12:
                        if ( (ttb=tb->getElementByType(IMAGEMAP))==NULL) {
				imageMap *c=new imageMap(tb);
				if (tb->canAdd(c)) {
					//ImageMapDialog *cd=new ImageMapDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				} else delete c;
			} else {
				//ImageMapDialog *cd=new ImageMapDialog(NULL,(imageMap *)ttb);
				//cd->exec();
			}
		break;
		case 13:
                        if ( (ttb=tb->getElementByType(COLORMAP))==NULL) {
				colorMap *c=new colorMap(tb);
				if (tb->canAdd(c)) {
					//ColorMapDialog *cd=new ColorMapDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				} else delete c;
			} else {
				//ColorMapDialog *cd=new ColorMapDialog(NULL,(colorMap *)ttb);
				//cd->exec();
			}
		break;
		case 14:
			if ( (ttb=tb->getElementByType(COLORLIST))==NULL) {
				colorList *c=new colorList(tb);
				if (tb->canAdd(c)) {
					//ColorListDialog *cd=new ColorListDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				} else delete c;
			} else {
				//ColorListDialog *cd=new ColorListDialog(NULL,(colorList *)ttb);
				//cd->exec();
			}
		break;
		case 15:
			if ( (ttb=tb->getElementByType(PIGMENTMAP))==NULL) {
				pigmentMap *c=new pigmentMap(tb);
				if (tb->canAdd(c)) {
					//PigmentMapDialog *cd=new PigmentMapDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//PigmentMapDialog *cd=new PigmentMapDialog(NULL,(pigmentMap *)ttb);
				//cd->exec();
			}
		break;
		case 16:
			if ( (ttb=tb->getElementByType(PIGMENTLIST))==NULL) {
				pigmentList *c=new pigmentList(tb);
				if (tb->canAdd(c)) {
					//PigmentListDialog *cd=new PigmentListDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//PigmentListDialog *cd=new PigmentListDialog(NULL,(PigmentList *)ttb);
				//cd->exec();
			}
		break;
		case 20:
			if ( (ttb=tb->getElementByType(NORMAL))==NULL) {
				normal *c=new normal(tb);
				if (tb->canAdd(c)) {
					//NormalDialog *cd=new NormalDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//NormalDialog *cd=new NormalDialog(NULL,(normal *)ttb);
				//cd->exec();
			}
		break;
		case 21:
			if ( (ttb=tb->getElementByType(BUMPMAP))==NULL) {
				bumpMap *c=new bumpMap(tb);
				if (tb->canAdd(c)) {
					//BumpMapDialog *cd=new BumpMapDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//BumpMapDialog *cd=new BumpMapDialog(NULL,(bumpMap *)ttb);
				//cd->exec();
			}
		break;
		case 22:
			if ( (ttb=tb->getElementByType(SLOPEMAP))==NULL) {
				slopeMap *c=new slopeMap(tb);
				if (tb->canAdd(c)) {
					//SlopeMapDialog *cd=new SlopeMapDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//lopeMapDialog *cd=new SlopeMapDialog(NULL,(slopeMap *)ttb);
				//cd->exec();
			}
		break;
		case 23:
			if ( (ttb=tb->getElementByType(NORMALMAP))==NULL) {
				normalMap *c=new normalMap(tb);
				if (tb->canAdd(c)) {
					//NormalMapDialog *cd=new NormalMapDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//NormalMapDialog *cd=new NormalMapDialog(NULL,(normalMap *)ttb);
				//cd->exec();
			}
		break;
		case 24:
			if ( (ttb=tb->getElementByType(NORMALLIST))==NULL) {
				normalList *c=new normalList(tb);
				if (tb->canAdd(c)) {
					//NormalListDialog *cd=new NormalListDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//NormalListDialog *cd=new NormalListDialog(NULL,(normalList *)ttb);
				//cd->exec();
			}
		break;

		case 30:
			if ( (ttb=tb->getElementByType(FINISH))==NULL) {
				finish *c=new finish(NULL);
				if (tb->canAdd(c)) {
					//FinishDialog *cd=new FinishDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				} else delete c;
			} else {
				//FinishDialog *cd=new FinishDialog(NULL,(finish *)ttb);
				//cd->exec();
			}
		break;
		case 40:
			if ( (ttb=tb->getElementByType(INTERIOR))==NULL) {
				interior *c=new interior(tb);
				if (tb->canAdd(c)) {
					//InteriorDialog *cd=new InteriorDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//InteriorDialog *cd=new InteriorDialog(NULL,(interior *)ttb);
				//cd->exec();
			}
		break;
		case 41:
                         if ( (ttb=tb->getElementByType(DENSITY))==NULL) {
				Density *c=new Density(tb);
				if (tb->canAdd(c)) {
					//DensityDialog *cd=new DensityDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//DensityDialog *cd=new DensityDialog(NULL,(Density *)ttb);
				//cd->exec();
			}
		break;
		case 50:

		break;
		case 51:

		break;
		case 64:
		{
			texture *t= new texture(tlib);
			tlib->add(t);
	
		}
		break;
		case 71:
                {
			TextureBook *c=new TextureBook(tb);
			tlib->add(c);
			c->setSelected(true);
		}
		break;

		case 72:
                {
				if (tb==NULL) tb=tlib;
				TextureBook *c=new TextureBook(tb);
				if (tb->canAdd(c)) {
					//DensityDialog *cd=new DensityDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
				//DensityDialog *cd=new DensityDialog(NULL,(Density *)ttb);
				//cd->exec();
		}
		break;
		case 80:
			if ( (ttb=tb->getElementByType(SURFACE))==NULL) {
				surface *c=new surface(tb);
				if (tb->canAdd(c)) {
					//SurfaceDialog *cd=new SurfaceDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//SurfaceDialog *cd=new SurfaceDialog(NULL,(surface *)ttb);
				//cd->exec();
			}
		break;

		case 81:
			if ( (ttb=tb->getElementByType(SURFACEMAP))==NULL) {
				surfaceMap *c=new surfaceMap(tb);
				if (tb->canAdd(c)) {
					//SurfaceMapDialog *cd=new SurfaceMapDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//SurfaceMapDialog *cd=new SurfaceMapDialog(NULL,(surfaceMap *)ttb);
				//cd->exec();
			}
		break;
		case 82:
			if ( (ttb=tb->getElementByType(SURFACELIST))==NULL) {
				surfaceList *c=new surfaceList(tb);
				if (tb->canAdd(c)) {
					//SurfaceListDialog *cd=new SurfaceListDialog(NULL,c);
					//cd->exec();
					tb->add(c);
					c->setSelected(true);
				}else delete c;
			} else {
				//SurfaceListDialog *cd=new SurfaceListDialog(NULL,(surfaceList *)ttb);
				//cd->exec();
			}
		break;
		default:
		break;
	}
	emit update();	
}
