/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturewindow.cpp
*/


#include <version.h>

#include <kapp.h>
#include <kfiledialog.h>
#include <kstatusbar.h>

#include "texturewindow.h"
#include "texturewindow.moc"



TextureWindow::TextureWindow(char *name) :
//	KTopLevelWidget(name)
	KTMainWindow(name)
{
KFileDialog	*fd;
QString		qstr;
char		name[1024];

	tview=new TextureView(this,(const char*)"");
        tlview=tview->getTextureListView();

	//tbtxtview=new TextureToolBar(this,tlview->getTextureLibrary() );

	connect(tlview,SIGNAL(newTextureSelection(textureBase*)),tbtxtview,SLOT(newTextureSel(textureBase*)) );
	connect(tbtxtview,SIGNAL(update),tlview,SLOT(updateAll()) );


	addToolBar(tbtxtview);	

	setView(tview);

	fd = new KFileDialog(i18n("Texturelibrary"));
	fd->setCaption(i18n("Open Library"));
	qstr = fd->getOpenFileName(prefs.getPath(prefs.getTexturePath()),"*.3dds",this,0);
	if(qstr == "") return;
	strcpy(name,qstr.data());
	delete fd;
	
	tlview->loadLib(name);
}

TextureWindow::~TextureWindow()
{
	if (tview) delete tview;
}


void	TextureWindow::paintEvent(QPaintEvent *pe)
{
	
	//tview->setGeometry(0,0,width(),height() );
	KTMainWindow::paintEvent(pe);
//	KTopLevelWidget::paintEvent(pe);
}

void	TextureWindow::show()
{
	KTMainWindow::show();
//	KTopLevelWidget::show();
}
