/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** turbulencewidget.cpp
*/
#include "turbulencewidget.h"
#include "turbulencewidget.moc"

#include <kapp.h>

TurbulenceWidget::TurbulenceWidget(QWidget *p,Turbulence *t) :
	TextureWidgetBase(p,"TurbulenceWidget")
{
        tr=t;

	turb=new VectorWidget(this,i18n("Turbulence"));
	turb->setVector(tr->getTurbulence());
	connect(turb,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	octaves=new SpinBox(this,"",tr->getOctaves() );
	oc=new QLabel(i18n("Octaves:"),this);
	connect(octaves,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );


        omega=new SpinBox(this,"",tr->getOmega() );
	om=new QLabel(i18n("Omega:"),this);
	connect(omega,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	lambda=new SpinBox(this,"",tr->getLambda() );
	la=new QLabel(i18n("Lambda:"),this);
	connect(lambda,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}

TurbulenceWidget::~TurbulenceWidget()
{
}

QSize TurbulenceWidget::sizeHint() const
{
	return qs;
}

void TurbulenceWidget::getValue()
{
	tr->setTurbulence(turb->getVector() );
	tr->setOmega(omega->getValue()  );	
	tr->setOctaves(octaves->getValue()  );	
	tr->setLambda(lambda->getValue()  );	
}

void TurbulenceWidget::paintEvent(QPaintEvent* qp)
{
int w1=turb->sizeHint().width();
int h1=turb->sizeHint().height();
int y=0,w=0,h=0,w2=0;
	
	turb->setGeometry(10,10,w1,h1);
        y+=h1+100;

	w=oc->sizeHint().width();
	h=octaves->sizeHint().height();		

	oc->setGeometry(w1+20,10,w,h);
	w2=octaves->sizeHint().width();
	octaves->setGeometry(w1+25+w,10,w2,h);

	om->setGeometry(w1+20,15+h,w,h);
	omega->setGeometry(w1+25+w,15+h,w2,h);

	la->setGeometry(w1+20,20+2*h,w,h);
	lambda->setGeometry(w1+25+w,20+2*h,w2,h);

	qs.setWidth(w1+25+w+w2);
	qs.setHeight(20+2*h+h+100);

	QWidget::paintEvent(qp);
}


