/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** transformwidget.cpp
*/
#include "transformwidget.h"
#include "transformwidget.moc"

#include <kapp.h>

TransformWidget::TransformWidget(QWidget *p,char *n) :
       	QWidget(p,n)
{
       	int		t;

       	for(t = 0;t < 3;t++)
       	{
       		la[t] = new QLabel(this);
       		vw[t] = new VectorWidget(this,0,1);
       	}
       	la[0]->setText(QString(i18n("Scale")) + ":");
       	la[1]->setText(QString(i18n("Rotate")) + ":");
       	la[2]->setText(QString(i18n("Translate")) + ":");
       	
       	connect(vw[0],SIGNAL(changed()),this,SIGNAL(changed()));
       	connect(vw[1],SIGNAL(changed()),this,SIGNAL(changed()));
       	connect(vw[2],SIGNAL(changed()),this,SIGNAL(changed()));
       	
       	layout();
}

TransformWidget::~TransformWidget()
{
}

QSize	TransformWidget::sizeHint()
{
       	int		w1,w2,ww,hh;
        QSize		qs;

       	w1 = MAX(MAX(la[0]->sizeHint().width(),la[1]->sizeHint().width())
       		,la[2]->sizeHint().width());
       	w2 = vw[0]->sizeHint().width();

	ww = w1 + w2 + 15;
	hh = 4 * MAX(vw[0]->sizeHint().height(),la[0]->sizeHint().height()) + 5 * 5;
	
	qs.setWidth(ww);
	qs.setHeight(hh);
	
	return qs;
}

void	TransformWidget::layout()
{
       	int		x,y,w,h,w1,w2/*,ww,hh*/;

       	w1 = MAX(
       		MAX(la[0]->sizeHint().width(),la[1]->sizeHint().width())
       		,la[2]->sizeHint().width());
       	w2 = vw[0]->sizeHint().width();

	x = 5;
	y = 5;
	w = w1;
	h = MAX(vw[0]->sizeHint().height(),la[0]->sizeHint().height());
	la[0]->setGeometry(x,y,w,h);
       	
       	x += w + 5;
       	w = w2;
       	vw[0]->setGeometry(x,y,w,h);

       	x = 5;
       	y += h + 5;
	w = w1;
	la[1]->setGeometry(x,y,w,h);
       	
       	x += w + 5;
       	w = w2;
       	vw[1]->setGeometry(x,y,w,h);

       	x = 5;
       	y += h + 5;
	w = w1;
       	la[2]->setGeometry(x,y,w,h);
       	
       	x += w + 5;
       	w = w2;
       	vw[2]->setGeometry(x,y,w,h);
}

void	TransformWidget::load(Vector3 sv,Vector3 rv,Vector3 tv)
{
      	vw[0]->setVector(sv);
       	vw[1]->setVector(rv);
       	vw[2]->setVector(tv);
}

void	TransformWidget::save(Vector3 &sv,Vector3 &rv,Vector3 &tv)
{
	sv = vw[0]->getVector();
	rv = vw[1]->getVector();
	tv = vw[2]->getVector();
}
