/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** vectorwidget.cpp
*/
#include "vectorwidget.h"
#include "vectorwidget.moc"

#include <kapp.h>
#include <misc.h>

VectorWidget::VectorWidget(QWidget *parent,const char *name,int lt) :
	QGroupBox(parent,name)
{
	setTitle(name);		

	title=new QLabel(name,this);

	layouttype = lt;
	
	vector = Vector3(0,0,0);

	allequal = false;
	check = new QCheckBox(i18n("all equal"),this);
	check->setChecked(allequal);

	if(layouttype == 0)
	{
		xe = new SpinBox(this,i18n("X"));
		ye = new SpinBox(this,i18n("Y"));
		ze = new SpinBox(this,i18n("Z"));
	}
	else
	{
		xe = new SpinBox(this,0);
		ye = new SpinBox(this,0);
		ze = new SpinBox(this,0);
	}

	connect(xe,SIGNAL(valueChanged()),this,SLOT(ValueChanged()));
	connect(ye,SIGNAL(valueChanged()),this,SLOT(ValueChanged()));
	connect(ze,SIGNAL(valueChanged()),this,SLOT(ValueChanged()));
	connect(check,SIGNAL(clicked()),this,SLOT(CheckPressed()));
	//connect(cl,SIGNAL(clicked()),this,SLOT(CheckPressed()));
	
	layout();
}

VectorWidget::~VectorWidget()
{
}



void	VectorWidget::CheckPressed()
{
	if(check->isChecked())
	{
       		xe->setLabel("");
       		ye->setEnabled(false);
       		ze->setEnabled(false);
       		allequal = true;
       		vector[1]=vector[0];
       		vector[2]=vector[0];
	}
	else
	{
       		xe->setLabel("X");
       		ye->setEnabled(true);
       		ze->setEnabled(true);
       		ye->setValue(vector[1]);
       		ze->setValue(vector[2]);
       		allequal = false;
	}
}

void	VectorWidget::ValueChanged()
{
	if(allequal==false)
	{
		vector[0]=xe->getValue();
		vector[1]=ye->getValue();
		vector[2]=ze->getValue();
	}
	else
	{
		vector[0]=xe->getValue();
		vector[1]=xe->getValue();
		vector[2]=xe->getValue();
	}
	
	emit changed();
}


QSize	VectorWidget::sizeHint()
{
	layout();
	
	return qs;
}

void	VectorWidget::paintEvent(QPaintEvent*)
{
	layout();
}

void	VectorWidget::layout()
{
	int	x=0,y=0,h2=0,w2=0,w3=0;
	int	w=0,h=0,ww=0,hh=0;


	w3 = title->sizeHint().width();
	h = title->sizeHint().height();

	title->setGeometry(0,0,w3,h);
	y += h + 5;

	if(layouttype == 0)
	{	
		w = xe->sizeHint().width();
		h = xe->sizeHint().height();

		xe->setGeometry(x,y,w,h);
       		y += 5 + h;

		ye->setGeometry(x,y,w,h);
       		y += 5 + h;

		ze->setGeometry(x,y,w,h);
    	   	y += 5 + h;

		w2 = check->sizeHint().width();
		h2 = check->sizeHint().height();

		check->setGeometry(x,y,w2,h2);
		y += h2 + 5;
	
		w=MAX(w,w2);
		w=MAX(w,w3);
			
		ww = w;
		hh = y;
	}
	else
	{	
		w = xe->sizeHint().width();
		h = xe->sizeHint().height();

		xe->setGeometry(x,y,w,h);
       		x += 5 + w;

		ye->setGeometry(x,y,w,h);
       		x += 5 + w;

		ze->setGeometry(x,y,w,h);
    	   	x += 5 + w;

		w2 = check->sizeHint().width();
		h2 = check->sizeHint().height();

		check->setGeometry(x,y,w2,h2);
		x += w2 + 5;

		h = MAX(xe->sizeHint().height(),check->sizeHint().height());
		
		ww = x;
		hh = h;
	}
	
	qs.setWidth(ww);	
	qs.setHeight(hh);
}

Vector3	VectorWidget::getVector()
{
	return vector;
}

void	VectorWidget::setVector(Vector3 v)
{
	vector = v;
	
	xe->setValue((vector[0]+0.1)-0.1);
	ye->setValue((vector[1]+0.1)-0.1);
	ze->setValue((vector[2]+0.1)-0.1);
	
	emit changed();
}



