// fire.cpp

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX(a,b)	(a < b ? b : a)
#define MIN(a,b)	(a > b ? b : a)
#define RANGE(a,b,c)	(MIN(c,MAX(a,b)))
#define SQR(a)		((a) * (a))

class cell
{
private:
	float	f_energy;
	float	f_speed[3];
	
public:
	cell(){f_energy = 0;f_speed[0] = 0;f_speed[1] = 0;f_speed[2] = 0;};
	~cell(){};
	
	void	setEnergy(float e){f_energy = e;};
	float	energy(){return f_energy;};
	
	void	setSpeedUp(float s){f_speed[1] = s;};
	void	setSpeedSide(float x,float z){f_speed[0] = x;f_speed[2] = z;};
	
	float	speedUp(){return f_speed[1];};
	float	speedX(){return f_speed[0];};
	float	speedZ(){return f_speed[2];};
};

class firebox
{
private:
	cell	*cellptr;
	int	h_div,v_div;
	
private:
	void	init();
	
	float	energyTransfare(cell *from,cell *to);
	void	transfareEnergy(cell *from,cell *to,float);
	
public:
	firebox(int h,int v)
	{
		h_div = h;
		v_div = v;
		
		init();
	}
	~firebox()
	{
		if(cellptr)
			delete [] cellptr;
	}
	
	cell	*getCell(int x,int y,int z);
	
	void	iterate(int steps = 1);
 	void	setHotSpot(float x,float y,float rad,float falloff);
 	
	void	print();
	void	exportDF3(const char *fn);
};

cell	*firebox::getCell(int x,int y,int z)
{
	if(x < 0 || x >= h_div)
		return 0;
	if(z < 0 || z >= h_div)
		return 0;
	if(y < 0 || y >= v_div)
		return 0;
		
	return cellptr + (x + y * h_div + z * h_div * v_div);
}

float	firebox::energyTransfare(cell *from_c,cell *to_c)
{
	float	de,fe,te;
	
	if(from_c)
		fe = from_c->energy();
	else
		fe = 0;
		
	if(to_c)
		te = to_c->energy();
	else
		te = 0;
		
	de = fe - te;
	
	return de / ((((float)rand()) / RAND_MAX * 0.5 + 1) * 16);
}

void	firebox::transfareEnergy(cell *from_c,cell *to_c,float energy)
{
	float	de,fe,te;
	
	if(from_c)
		from_c->setEnergy(from_c->energy() - energy);
		
	if(to_c)
		to_c->setEnergy(to_c->energy() + energy);
}

void	firebox::init()
{
	int	x,y,z;
	cell	*cp;
	float	r;
	
	cellptr = new cell[h_div * h_div * v_div];

	for(y = 0;y < v_div;y++)
		for(x = 0;x < h_div;x++)
			for(z = 0;z < h_div;z++)
			{
				cp = getCell(x,y,z);
				cp->setEnergy(0);
				cp->setSpeedUp(0);
				cp->setSpeedSide(0,0);
			}
/*
	for(x = 0;x < h_div;x++)
		for(z = 0;z < h_div;z++)
		{
			r = sqrt(SQR((float)(x * 2) / (float)h_div - 1)
			  + SQR((float)(z * 2) / (float)h_div - 1));
			
			cp = getCell(x,0,z);
			cp->setEnergy(RANGE(0,1 - r * 2,1));
			cp->setSpeedUp(0.5);
			cp->setSpeedSide(0,0);
		}
*/
	setHotSpot((float)rand() / RAND_MAX,	// x
		(float)rand() / RAND_MAX,	// y
		pow((float)rand() / RAND_MAX,3) / 3,	// rad
		(float)rand() / RAND_MAX * 2);	// falloff
	setHotSpot((float)rand() / RAND_MAX,	// x
		(float)rand() / RAND_MAX,	// y
		pow((float)rand() / RAND_MAX,3) / 3,	// rad
		(float)rand() / RAND_MAX * 2);	// falloff
	setHotSpot((float)rand() / RAND_MAX,	// x
		(float)rand() / RAND_MAX,	// y
		pow((float)rand() / RAND_MAX,3) / 3,	// rad
		(float)rand() / RAND_MAX * 2);	// falloff
	setHotSpot((float)rand() / RAND_MAX,	// x
		(float)rand() / RAND_MAX,	// y
		pow((float)rand() / RAND_MAX,3) / 3,	// rad
		(float)rand() / RAND_MAX * 2);	// falloff
}
	
void	firebox::iterate(int steps)
{
	int	x,y,z;
	cell	*cp,*cpd;
	float	e;

	for(y = 1;y < v_div;y++)
		for(x = 0;x < h_div;x++)
			for(z = 0;z < h_div;z++)
			{
				cp = getCell(x,y,z);
				
				// calculate energy-transfare
				e = energyTransfare(cp,getCell(x + 1,y,z));
				transfareEnergy(cp,getCell(x + 1,y,z),e);
				e = energyTransfare(cp,getCell(x,y,z + 1));
				transfareEnergy(cp,getCell(x,y,z + 1),e);
				e = energyTransfare(cp,getCell(x - 1,y,z));
				transfareEnergy(cp,getCell(x - 1,y,z),e);
				e = energyTransfare(cp,getCell(x,y,z - 1));
				transfareEnergy(cp,getCell(x,y,z - 1),e);
				
				e = energyTransfare(cp,getCell(x,y + 1,z));
				transfareEnergy(cp,getCell(x,y + 1,z),e * 1.3);
				
				e = energyTransfare(cp,getCell(x,y,z - 1));
				transfareEnergy(cp,getCell(x,y,z - 1),e);
				e = energyTransfare(cp,getCell(x - 1,y,z));
				transfareEnergy(cp,getCell(x - 1,y,z),e);
				e = energyTransfare(cp,getCell(x,y,z + 1));
				transfareEnergy(cp,getCell(x,y,z + 1),e);
				e = energyTransfare(cp,getCell(x + 1,y,z));
				transfareEnergy(cp,getCell(x + 1,y,z),e);
			}
	for(y = v_div - 2;y > 0;y--)
		for(x = 0;x < h_div;x++)
			for(z = 0;z < h_div;z++)
			{
				cp = getCell(x,y,z);
				cpd = getCell(x,y - 1,z);
				
				cp->setEnergy(RANGE(0,cpd->energy(),1));
			}
	for(x = 0;x < h_div;x++)
		for(z = 0;z < h_div;z++)
		{
			cp = getCell(x,0,z);
			
			cp->setEnergy(cp->energy() / 1.5);
		}
		
	{
		float	x,z,r,f;
		int	i;
		
		for(i = 0;i < 24;i++)
		{
			x = RANGE(0.3,(float)rand() / RAND_MAX,0.7);
			z = RANGE(0.3,(float)rand() / RAND_MAX,0.7);
			r = pow((float)rand() / RAND_MAX,3) * 0.1;
			f = (float)rand() / RAND_MAX;
		
			setHotSpot(x,z,r,f);
		}
	}
}

void	firebox::setHotSpot(float sx,float sz,float sr,float sf)
{
	int	x,z;
	int	minx,maxx,minz,maxz;
	float	r,f;
	cell	*cp;
	
	minx = (int)(RANGE(0,sx - sr,1) * h_div);
	maxx = (int)(RANGE(0,sx + sr,1) * h_div);
	minz = (int)(RANGE(0,sz - sr,1) * h_div);
	maxz = (int)(RANGE(0,sz + sr,1) * h_div);
	
	for(x = minx;x < maxx;x++)
		for(z = minz;z < maxz;z++)
		{
			r = sqrt(SQR(sx - (float)(x) / (float)h_div)
			  + SQR(sz - (float)(z) / (float)h_div));
			f = pow(RANGE(0,1 - r,1),sf);
			
			cp = getCell(x,0,z);
			
			cp->setEnergy(RANGE(0,cp->energy() + f,1));
		}
}

void	firebox::print()
{
	int	x,y,z;
	char	c[] = "ffff .,-+o*#Xffff";
	
	z = h_div / 2;
	
	for(y = v_div - 1;y > 0;y--)
	{
		for(x = 0;x < h_div;x++)
			printf("%c",c[(int)(getCell(x,y,z)->energy() * 8) + 4]);
		printf("\n");
	}
}

void	firebox::exportDF3(const char *fn)
{
	int	x,y,z;
	cell	*cp;
	FILE	*fp;
	

	fp = fopen(fn,"w");

	fputc((unsigned char)((h_div & 0xff00) >> 8),fp);
	fputc((unsigned char)(h_div & 0x00ff),fp);
	fputc((unsigned char)((v_div & 0xff00) >> 8),fp);
	fputc((unsigned char)(v_div & 0x00ff),fp);
	fputc((unsigned char)((h_div & 0xff00) >> 8),fp);
	fputc((unsigned char)(h_div & 0x00ff),fp);

	for(x = 0;x < h_div;x++)
		for(y = 0;y < v_div;y++)
			for(z = 0;z < h_div;z++)
			{
				cp = getCell(x,y,z);
				fputc((unsigned char)(RANGE(0,cp->energy(),1) * 255),fp);
			}
	fclose(fp);
}
	
void	main(int argc,char **argv)
{
	int		h,v,n;
	int		t;
	bool		po;
	
	h = 20;
	v = 20;
	n = 25;
	po = false;
	
	if(argc > 1)
		h = atoi(argv[1]);
	if(argc > 2)
		v = atoi(argv[2]);
	if(argc > 3)
		n = atoi(argv[3]);
	if(argc > 4)
		po = true;
		
	firebox		fb(h,v);
	
	
	for(t = 0;t < n;t++)
	{
		if(po)
			fb.print();
		else
		{
			printf(".");
			fflush(stdout);
		}
		
		fb.iterate();
	}
	if(po)
		fb.print();
	printf("ready\n");

	fb.exportDF3("test.df3");
}
