/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** glyph.cpp
*/
#include <string.h>
#include <stdlib.h>

#include <misc.h>

#include "glyph.h"

fontglyph::fontglyph()
{
	name = 0;
	ncontours = 0;
	npoints = 0;
	points = 0;
	flags = 0;
	contours = 0;
}

fontglyph::fontglyph(char *n)
{
	name = strdup(n);
	ncontours = 0;
	npoints = 0;
	points = 0;
	flags = 0;
	contours = 0;
}

fontglyph::fontglyph(char c)
{
	switch(c)
	{
		case ' ':
			name = strdup("Space");
		break;
		case '\t':
			name = strdup("Tab");
		break;
		case '\n':
			name = strdup("Carrige Return");
		break;
		default:
			name = (char*)malloc(2);
			name[0] = c;
			name[1] = '\0';
	}
		
	ncontours = 0;
	npoints = 0;
	points = 0;
	flags = 0;
	contours = 0;
}

fontglyph::~fontglyph()
{
	if(name) free(name);
	if(points) free(points);
	if(flags) free(flags);
	if(contours) free(contours);
}

void	fontglyph::setName(char *n)
{
	if(name) free(name);
	name = strdup(n);
}

void	fontglyph::setName(char c)
{
	if(name) free(name);
	switch(c)
	{
		case ' ':
			name = strdup("Space");
		break;
		case '\t':
			name = strdup("Tab");
		break;
		case '\n':
			name = strdup("Carrige Return");
		break;
		default:
			name = (char*)malloc(2);
			name[0] = c;
			name[1] = '\0';
	}
}

char	*fontglyph::getName()
{
	return name;
}

void	fontglyph::addPoint(Vector2 &p,int onpoint)
{
	points = (Vector2*)realloc(points,(npoints + 1) * sizeof(Vector2));
	if(!points)
	{
		npoints = 0;
		if(flags) free(flags);
		flags = 0;
		if(contours) free(contours);
		contours = 0;
		ncontours = 0;

		return;
	}
	points[npoints] = p;
	flags= (char*)realloc(flags,(npoints + 1) * sizeof(char));
	if(!flags)
	{
		npoints = 0;
		if(points) free(points);
		points = 0;
		if(contours) free(contours);
		contours = 0;
		ncontours = 0;

		return;
	}
	flags[npoints] = !onpoint;
	npoints++;
}

void	fontglyph::addContour(int pointn)
{
	if(pointn > npoints) return;

	contours = (int*)realloc(contours,(ncontours + 1) * sizeof(int));
	if(!contours)
	{
		ncontours = 0;
		if(flags) free(flags);
		flags = 0;
		if(points) free(points);
		points = 0;
		npoints = 0;

		return;
	}
	contours[ncontours] = pointn;
	ncontours++;
}

int	fontglyph::nPoints()
{
	return npoints;
}

int	fontglyph::isOnPoint(int n)
{
	if(n < 0 || n >= npoints) return -1;
	return !flags[n];
}

Vector2	fontglyph::getPoint(int n)
{
	Vector2		v;

	if(n < 0 || n >= npoints)
		return v;

	return points[n];
}

int	fontglyph::nContours()
{
	return ncontours + 1;
}

int	fontglyph::getContourStartPoint(int n)
{
	if(n < 0 || n > ncontours) return -1;
	if(n == 0)
		return 0;
	return contours[n - 1] + 1;
}

int	fontglyph::getContourEndPoint(int n)
{
	if(n < 0 || n > ncontours) return -1;
	if(n == ncontours)
		return npoints - 1;
	return contours[n];
}

double	fontglyph::width()
{
	double	min,max;
	int	p;

	min = getPoint(0)[0];
	max = min;
	for(p = 1;p < nPoints();p++)
	{
		if(isOnPoint(p))
		{
			min = MIN(min,getPoint(p)[0]);
			max = MAX(max,getPoint(p)[0]);
		}
	}

	return max - min;
}

double	fontglyph::height()
{
	double	min,max;
	int	p;

	min = getPoint(0)[1];
	max = min;
	for(p = 1;p < nPoints();p++)
	{
		if(isOnPoint(p))
		{
			min = MIN(min,getPoint(p)[1]);
			max = MAX(max,getPoint(p)[1]);
		}
	}

	return max - min;
}

double	fontglyph::ascend()
{
	double	max;
	int	p;

	max = getPoint(0)[1];
	for(p = 1;p < nPoints();p++)
	{
		if(isOnPoint(p))
		{
			max = MAX(max,getPoint(p)[1]);
		}
	}

	return max;
}

double	fontglyph::descend()
{
	double	min;
	int	p;

	min = getPoint(0)[1];
	for(p = 1;p < nPoints();p++)
	{
		if(isOnPoint(p))
		{
			min = MIN(min,getPoint(p)[1]);
		}
	}

	return min;
}

double	fontglyph::space()
{
	return a;
}

void	fontglyph::setSpace(double n)
{
	a = n;
}

