#include <kapp.h>
#include "kblinselwidget.h"
#include "kblinselstereogram.h"
#include <qcolor.h>

KBlinselWidget::KBlinselWidget(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
 kimgioRegister(); // init KIMGIO Ext

 // Read the config file
 config = KApplication::getKApplication()->getConfig();	

 config->setGroup("Pattern");

 printer = new QPrinter();
 loaded = 0;

 panner = new KNewPanner(this,0,KNewPanner::Vertical,KNewPanner::Absolute,40);
 // Set up and scan the patterns and do the view :-)
 patternview = new QListBox(panner);
 patternview->setGeometry(0,0,100,400);
// patternview->setMinimumSize(0,00);
// pa
 connect(new KDNDDropZone(patternview , DndURL),
	        SIGNAL(dropAction(KDNDDropZone *)),
	        SLOT(slotDropEvent(KDNDDropZone *)));

 connect(patternview,SIGNAL(highlighted(int)),SLOT(setPattern(int)));
 scanPatternDir();
 labelImg = new QLabel(panner);
 panner->activate(patternview,labelImg);
}

KBlinselWidget::~KBlinselWidget()
{
}


void KBlinselWidget :: slotDropEvent(KDNDDropZone *zone)
{
 QString u = zone->getURLList().first();
 u.remove(0,5);
 patternview->insertItem(*(new QPixmap(u.data())));
}



void KBlinselWidget::resizeEvent( QResizeEvent * )
{
 panner->setGeometry(0,0,width(),height());
}


void KBlinselWidget::loadImg()
{
 //delete(labelImg);
 QString *filename;
 filename = new QString();
 *filename = KFileDialog::getOpenFileName();
 if(filename->isEmpty()==TRUE) return;
 if(pm.load(*filename)==FALSE) { KMsgBox::message(0,"Error","File couldn't be opened!",KMsgBox::EXCLAMATION); return; }
 setFixedSize(pm.width()+panner->absSeparatorPos(),pm.height());
 loaded = 1;
 //labelImg->setGeometry(0,0,pm.width(),pm.height());
 labelImg->setPixmap(pm);
 img = pm;
 emit pleasedraw();
 labelImg->show();
}

void KBlinselWidget::loadImg(QString *filename)
{
 //delete(labelImg);
 if(filename->isEmpty()==TRUE) return;
 if(pm.load(*filename)==FALSE) { KMsgBox::message(0,"Error","File couldn't be opened!",KMsgBox::EXCLAMATION); return; }
 setFixedSize(pm.width()+panner->absSeparatorPos(),pm.height());
 loaded = 1;
 //labelImg->setGeometry(0,0,pm.width(),pm.height());
 labelImg->setPixmap(pm);
 img = pm;
 emit pleasedraw();
 labelImg->show();
}

void KBlinselWidget::saveImg()
{
 if(loaded != 1) {KMsgBox::message(0,"No File open","There is no open file to save!\nClick on File->Open... to load a file",KMsgBox::EXCLAMATION); return;} // Ist Datei berhaupt geffnet???
 QString *filename;
 QString *filetype;
 filetype = new QString();
 filename = new QString();
 *filename = KFileDialog::getSaveFileName();   // Datei Speichern Dialog
 if(filename->isEmpty()==TRUE) return; // Dateiname angegeben??
 *filetype = filename->right(3);
 if(img1.save(*filename,filetype->upper())==FALSE) {KMsgBox::message(0,"Error","File couldn't be saved!",KMsgBox::EXCLAMATION); return;} // Speichern...speichern nicht funktionier? zurck
}

void KBlinselWidget::printImg()
{
 if(loaded != 1) {KMsgBox::message(0,"No File open","There is no open file to print!\nClick on File->Open... to load a file",KMsgBox::EXCLAMATION); return;} // Ist Datei berhaupt geffnet???
 if(printdlg->getPrinterSetup(printer)==TRUE)
 {
  QPixmap logo;
  logo.load("logo.xpm");
  painter = new QPainter();
  painter->begin(printer);
  painter->drawPixmap(10,10,logo);
  painter->drawPixmap(10,80,pm);
  painter->end();
  delete(painter);
 }
}

void KBlinselWidget::genStereo()
{
 if(loaded != 1) {KMsgBox::message(0,"No File open","There is no open file to generate a SIRD from!\nClick on File->Open... to load a file",KMsgBox::EXCLAMATION); return;} // Ist Datei berhaupt geffnet???
 // <Deiminger Algo Part>
 // KBlinselStereogram algo(img);
 algo.setSource(img);
 img1 = algo.calc();

 //delete(labelImg);
 pm = img1;
 labelImg->setGeometry(panner->absSeparatorPos(),0,pm.width(),pm.height());
 labelImg->setPixmap(pm);
 labelImg->show();
 repaint();
 // </Deiminger Algo Part>
}

void KBlinselWidget::togglePattern(bool flag)
{
 algo.use_texturing = flag;
}

void KBlinselWidget::configure()
{
 configDlg = new KBlinselConfig(config);
 connect(configDlg,SIGNAL(isready(bool)),SLOT(confReturn(bool)));
}

void KBlinselWidget::confReturn(bool flag)
{
if(flag == true)
 {
  patternview->clear();
 scanPatternDir();
 config->sync();
 }
}


void KBlinselWidget::scanPatternDir()
{
 QString *temp,*pattdir,*nfilter;
 temp = new QString();
 pattdir = new QString(config->readEntry("PatternDir",KApplication::kde_datadir()+"/kblinsel/patterns/"));
 nfilter = new QString(config->readEntry("PatternSuffix","*.xpm"));
 patternDir = new QDir(*pattdir);
 if ( !patternDir->exists() ) { KMsgBox::message(0,"Error","Cannot find the pattern directory!\nClick on the Configure Button an enter a valid path" ); return;}

 patternDir->setNameFilter(*nfilter);
 const QFileInfoList *list = patternDir->entryInfoList();
 QFileInfoListIterator it( *list );      // create list iterator
 QFileInfo *fi;                          // pointer for traversing
 while ( (fi=it.current()) )
 {
  *temp = *pattdir + fi->fileName();
  patternview->insertItem(*(new QPixmap(temp->data())));
  ++it;
 }
}


void KBlinselWidget::setPattern(int index)
{
 QImage pattern;
 pattern  = *(patternview->pixmap(index));
 algo.setTexture(pattern);
}