#include<math.h>
#include<stdio.h>
#include<stdlib.h>
#include<limits.h>
#include"engine.moc"
#include"engine.h"
#include"surfaces.h"
#include"screen.h"

Color::Color()
{
  r = g = b = 0.0;
}

Color::Color(double R, double G, double B)
{
  r = R; g = G; b = B;
}

inline
rayT::rayT(Vector P, Vector N) : p(P), n(N)
{ };

inline
rayT::rayT() : p(), n()
{ };

inline
kugelT::kugelT(Vector M, double Sqrr) : m(M)
{
  sqrr = Sqrr;
}

static Vector eye(  2.0, -8.0, 1.6 );
static Vector LightV(  -2.0, -4.0, 2.0 );
static Color LightC( 0.6, 0.6, 0.6 );
static Color AmbC(  0.1, 0.1, 0.1 );


static kugarrT KugelArr = {
  kugelT( Vector( 2.2, -1.5, 1.0 ) , 1.0 ),
  kugelT( Vector( -0.2, -4.0, 1.3 ), 1.3*1.3 )
};

static Surface* ObArr[3+anzKugel];
static bool SavePic, Showscreen;

void Engine::errEps(double s)
{
  if (fabs(s) >= Epsilon)
    return;
  fprintf(stderr, "KRay exit with Error (Div by 0)\n");
  exit(1);
}



Vector Engine::RayToPoint(rayT r, double l)
{
  Vector p;
  p.x = r.p.x + l * r.n.x;
  p.y = r.p.y + l * r.n.y;
  p.z = r.p.z + l * r.n.z;
  return p;
}


Vector Engine::ReflV(Vector ve, Vector n)
{
  
  double w;
  Vector v;

  w = ve * n * 2;
  v = n*w - ve;
  return v;
}


bool Engine::TransV(Vector ve, Vector n, double n1, double n2, Vector& vt)
{
  bool Result;
  double p, q, c, d;

  p = n1 / n2;
  c = fabs(ve*n);
  d = 1 - p * p * (1 - c * c);
  if (d < 0.0)
    return false;
  q = p * c - sqrt(d);
  Result = true;
  ve *= p;
  n *= q;
  vt = ve+n;
  return Result;
}

double Engine::pow(double x, double y)
{
  x = log(x) * y;
  if (x < -10)
    return 0.0;
  else
    return exp(x);
}


void Engine::sqrSolve(double p, double q, double *lam)
{
  double d, h, l1, l2;

  d = p * p * 0.25 - q;
  if (d < 0) {
    *lam = Infinity;
    return;
  }
  h = -p * 0.5;
  d = sqrt(d);
  l1 = h + d;
  l2 = h - d;
  if (l2 < l1 && l2 > Epsilon) {
    *lam = l2;
    return;
  }
  if (l1 > Epsilon)
    *lam = l1;
  else
    *lam = Infinity;
}


void Engine::intersect(rayT *r, long *obNr, double *lMin)
{
  double p, q, pMmNrm, l;
  Vector pMm;
  uchar i;

  r->n.normalize();
  if (r->n.z > 0) {
    if (r->p.z > 0)
      *obNr = 0;
    else
      *obNr = 2;
  } else {
    if (r->p.z < 0)
      *obNr = 1;
    else
      *obNr = 2;
  }
  if (*obNr == 2) {
    *lMin = -(r->p.z / r->n.z);
    if (*lMin < 0)
      *lMin = Infinity;
  } else
    *lMin = Infinity;
  for (i = 1; i <= anzKugel; i++) {
    pMm = r->p - KugelArr[i - 1].m;
    pMmNrm = pMm.norm();
    p = pMm * r->n * 2;
    q = pMmNrm * pMmNrm - KugelArr[i - 1].sqrr;
    sqrSolve(p, q, &l);
    if (l < *lMin) {
      *obNr = i + 2;
      *lMin = l;
    }
  }
}


bool Engine::InShadow(Vector p)
{
  rayT r;
  long ShdNr;
  double dummy;

  r.p = p;
  r.n = LightV;
  r.p = RayToPoint(r, 0.001);
  intersect(&r, &ShdNr, &dummy);
  return (ShdNr > 1);
}


bool Engine::GetNrm(long ObNr, Vector p, Vector ve, Vector& n)
{
  Vector nn;

  if (ObNr == 2)
    n = Vector(0.0, 0.0, 1.0);
  else {
    if (ObNr >= 3 && ObNr <= anzKugel + 2) {
      n = p - KugelArr[ObNr - 3].m;
      n.normalize();
    }
  }
  if (ve * n < 0)
    n *= (-1.0);
  nn = n;
  n = ObArr[ObNr]->getNorm(p, n);
  n.normalize();
  return ((ve * n) > 0 && (nn * n) > 0);
}


Color Engine::Light(long ObNr, Vector p, Vector n, Vector, Vector vr)
{
  double w1, w2, spec;
  Color cd, cs, c;

// Once again we are using OO
  cd = ObArr[ObNr]->getColor(p);
// End OO
  w1 = LightV * n;
  if (w1 > 0 && !InShadow(p)) {
    c.r = (LightC.r * w1 + AmbC.r) * cd.r;
    c.g = (LightC.g * w1 + AmbC.g) * cd.g;
    c.b = (LightC.b * w1 + AmbC.b) * cd.b;
    w2 = vr *  LightV;
    if (w2 <= 0)
      return c;
    spec = pow(w2, ObArr[ObNr]->Oe);
    cs = ObArr[ObNr]->SpecC;
    c.r += spec * cs.r;
    c.g += spec * cs.g;
    c.b += spec * cs.b;
    return c;
  }
  c.r = AmbC.r * cd.r;
  c.g = AmbC.g * cd.g;
  c.b = AmbC.b * cd.b;
  return c;
}


Color Engine::trace(rayT r, long RekDep, double N1, double atten)
{
  long obNr;
  double lMin, as, at;
  Vector p, n, ve, vr, vt;
  Color ci, cs, c;
  bool toRefl, toTrans;

  if (RekDep > maxRekDep || atten < AttenEps) {
    c.r = 0.0;
    c.g = 0.0;
    c.b = 0.0;
    return c;
  }
  intersect(&r, &obNr, &lMin);
  if (obNr < 2) {
    c = ObArr[obNr]->getColor(r.n);
  }
  else {
    p = RayToPoint(r, lMin);
    ve = eye - p;
    ve.normalize();
    toRefl = GetNrm(obNr, p, ve, n);
    vr = ReflV(ve, n);
    c = Light(obNr, p, n, ve, vr);
    if (ObArr[obNr]->Refl && toRefl) {
      r.p = p;
      r.n = vr;
      r.p = RayToPoint(r, 0.001);
      cs = ObArr[obNr]->SpecC;
      if (cs.r > cs.g && cs.r > cs.b)
	as = atten * cs.r;
      else {
	if (cs.g > cs.b)
	  as = atten * cs.g;
	else
	  as = atten * cs.b;
      }
      ci = trace(r, RekDep + 1, 1.0, as);
      c.r += ci.r * cs.r;
      c.g += ci.g * cs.g;
      c.b += ci.b * cs.b;
    }
    if (ObArr[obNr]->Trans) {
      if (N1 != 1)
	toTrans = TransV(ve, n, N1, 1.0, vt);
      else
	toTrans = TransV(ve, n, 1.0, ObArr[obNr]->N, vt);
      if (toTrans) {
	r.p = p;
	r.n = vt;
	r.p = RayToPoint(r, 0.001);
	if (N1 != 1)
	  N1 = 1.0;
	else
	  N1 = ObArr[obNr]->N;
	cs = ObArr[obNr]->TransC;
	if (cs.r > cs.g && cs.r > cs.b)
	  at = atten * cs.r;
	else {
	  if (cs.g > cs.b)
	    at = atten * cs.g;
	  else
	    at = atten * cs.b;
	}
	ci = trace(r, RekDep + 1, N1, at);
	c.r += ci.r * cs.r;
	c.g += ci.g * cs.g;
	c.b += ci.b * cs.b;
      }
    }
  }
  return c;
}



/* Local variables for dNoise: */




void Engine::SetProp(uchar ObNr, int Nr)
{
  switch (Nr) {
  case 0:
    ObArr[ObNr] = new SkySurface;
    break;
  case 1:
    ObArr[ObNr] = new HellSurface;
    break;
  case 2:
    ObArr[ObNr] = new Marble;
    break;
  case 3:
    ObArr[ObNr] = new Water;
    break;
  case 4:
    ObArr[ObNr] = new Glass;
    break;
  case 5:
    ObArr[ObNr] = new Mirror;
    break;
  case 6:
    ObArr[ObNr] = new Brass;
    break;
  case 7:
    ObArr[ObNr] = new RedSurface;
    break;
  case 8:
    ObArr[ObNr] = new GreenSurface;
    break;
  }
}


Engine::Engine(int x, int y, int surf1, int surf2, int surf3, int surf4, int surf5)
  : QObject()
{
  // Setting the ObArray according to parameters
  SetProp(0, (surf1<2 ? surf1 : surf1+5));//  der Himmel
  SetProp(1, (surf2<2 ? surf2 : surf2+5));//  die Hlle
  SetProp(2, surf3);//  der Boden
  SetProp(3, surf4);//  the small Sphere
  SetProp(4, surf5);//  the big Sphere
  // Setting the picture size
  xmax = x-1;
  ymax = y-1;
}

void Engine::paintPixel(int x, int y, int r, int g, int b)
{
  // IPC over stdout
  printf("%.3u%.3u%.3u%.3u%.3u",x,y,r,g,b);
  //printf("%i %i %i ",r,g,b);
}

void Engine::calculate()
{
  long x, y, i, j, k;
  rayT r;
  double h, v;
  Vector vh, hv, vr, nh;
  Color c;
  uchar cr, cg, cb;

  SavePic = true;
  Showscreen = true;
  for (i = 0; i < LatCnt; i++) {
    for (j = 0; j < LatCnt; j++) {
      for (k = 0; k < LatCnt; k++)
	Surface::Lattice[i][j][k] = (int)((double)256*((double)rand()
						       /(double)RAND_MAX)); 
    }
  }
  r.p = eye;
  errEps(eye.z);
  LightV.normalize();

  vh.x = -eye.x;
  vh.y = -eye.y;
  vh.z = (eye.x * eye.x + eye.y * eye.y + eye.z * eye.z) / eye.z;
  vh.normalize();
  if (eye.z < 0)
    vh *= (-1.0);

  vr.x = vh.y * eye.z - vh.z * eye.y;
  vr.y = vh.z * eye.x - vh.x * eye.z;
  vr.z = vh.x * eye.y - vh.y * eye.x;
  vr.normalize();
  // printf("P3 %d %d 255\n",xmax+1, ymax+1);
  for (y = 0; y <= ymax; y++) {
    h = (0.5 - (double)y / ymax) * ymax / xmax * PicSizeWC;
    hv = vh*h;
    for (x = 0; x <= xmax; x++) {
      v = ((double)x / xmax - 0.5) * PicSizeWC;
      nh = vr*v;
      nh += hv;
      r.n = nh - eye;
      c = trace(r, 0L, 1.0, 1.0);
      if (c.r > 1)
	c.r = 1.0;
      if (c.g > 1)
	c.g = 1.0;
      if (c.b > 1)
	c.b = 1.0;
      cr = (long)floor(c.r * 255 + 0.5);
      cg = (long)floor(c.g * 255 + 0.5);
      cb = (long)floor(c.b * 255 + 0.5);
      //      printScreen->drawPixel(x,y,cr,cg,cb);
      paintPixel(x, y, cr, cg, cb);
    }
    //    fprintf(stderr,"[%ld]",y);
  }
}




/* End. */
