#include <stdlib.h>
#include <unistd.h>
#include <qlabel.h>
#include <qchkbox.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qaccel.h>
#include <kapp.h>
#include <qmsgbox.h>
#include <klocale.h>

#include "raywidget.h"
#include "raywidget.moc"
#include "screen.h"

dlgRay::dlgRay (QWidget* , const char* name)
	: KTopLevelWidget( name )
{
  setCaption("KRay");
  initMenu();
  initDialogElements();
  
  resize( 310,380 );
  setMinimumSize( 310, 380 );
  setMaximumSize( 310, 380 );

  connect( xsize, SIGNAL(textChanged(const char*)), SLOT(updateYsize(const char*)) );
}

void dlgRay::closeEvent ( QCloseEvent *e)
{
  quit();
  e->accept();
}

dlgRay::~dlgRay()
{
}

void dlgRay::quit()
{
  //Maybe: saveOptions()
  delete File;
  delete Help;
  delete Menu;
  kapp->quit();
}


void dlgRay::updateYsize(const char* xText)
{
  if (ratioCheckbox->isChecked()) {
    QString s(xText);
    uint y = s.toUInt();
    y *= 3;
    y /= 4;
    s.setNum(y);
    ysize->setText((const char*)s);
  }
}

void dlgRay::generate()
{
  QString xs,ys;
  int x,y;
  Screen* newWidget;

  xs = QString(xsize->text());
  ys = QString(ysize->text());
  x = xs.toInt();
  y = ys.toInt();
  if (x > 99 && y > 74 && x < 801 && y < 601) {
    newWidget = new Screen(x, y, 
			   SkySurface->currentItem(),
			   HellSurface->currentItem(),
			   GroundSurface->currentItem(),
			   Sphere1Surface->currentItem(),
			   Sphere2Surface->currentItem());
    newWidget->show();
  }
  else {
    QMessageBox::warning( this, "KRay",
			  klocale->translate( "The size of the picture is outside of the allowed parameters\n" ));
      };
}

void dlgRay::initMenu()
{
  Menu = new QMenuBar(this);
  File = new QPopupMenu;
  Help = kapp->getHelpMenu(0,"KRay V0.1 was written by Torsten Reu\n\nPlease send bug-reports to torsten.reuss@uni-muenster.de");

  // Main Menu
  CHECK_PTR( Menu );
  Menu->insertItem(klocale->translate( "&File" ), File);
  Menu->insertSeparator();
  Menu->insertItem(klocale->translate( "&Help" ), Help);

  // File Menu
  File->insertItem(klocale->translate( "&Generate Picture" ), this, SLOT(generate()), ALT + Key_G );
  File->insertItem(klocale->translate( "E&xit" ), qApp, SLOT(quit()), ALT + Key_Q );
}

void dlgRay::initDialogElements()
{
  // Dialog Elements
  QGroupBox* groupbox1;
  groupbox1 = new QGroupBox( this, "gbox1" );
  groupbox1->setGeometry( 10, 30, 290, 80 );
  groupbox1->setMinimumSize( 10, 10 );
  groupbox1->setMaximumSize( 32767, 32767 );
  groupbox1->setFrameStyle( 33 );
  groupbox1->setTitle(klocale->translate( "Picture Size" ));

  QGroupBox* groupbox2;
  groupbox2 = new QGroupBox( this, "gbox2" );
  groupbox2->setGeometry( 10, 115, 290, 210 );
  groupbox2->setMinimumSize( 10, 10 );
  groupbox2->setMaximumSize( 32767, 32767 );
  groupbox2->setFrameStyle( 33 );
  groupbox2->setTitle(klocale->translate( "Surfaces" ));

  xsize = new QLineEdit( this, "xedit" );
  xsize->setGeometry( 50, 50, 50, 30 );
  xsize->setMinimumSize( 10, 10 );
  xsize->setMaximumSize( 32767, 32767 );
  xsize->setText( "400" );
  xsize->setMaxLength( 5 );
  xsize->setEchoMode( QLineEdit::Normal );
  xsize->setFrame( TRUE );

  ysize = new QLineEdit( this, "yedit" );
  ysize->setGeometry( 140, 50, 50, 30 );
  ysize->setMinimumSize( 10, 10 );
  ysize->setMaximumSize( 32767, 32767 );
  ysize->setText( "300" );
  ysize->setMaxLength( 32767 );
  ysize->setEchoMode( QLineEdit::Normal );
  ysize->setFrame( TRUE );

  QLabel* label1;
  label1 = new QLabel( this, "Label_1" );
  label1->setGeometry( 20, 50, 20, 30 );
  label1->setMinimumSize( 10, 10 );
  label1->setMaximumSize( 32767, 32767 );
  label1->setText( "X:" );
  label1->setAlignment( AlignLeft | AlignVCenter );
  label1->setMargin( -1 );

  QLabel* label2;
  label2 = new QLabel( this, "Label_2" );
  label2->setGeometry( 110, 50, 20, 30 );
  label2->setMinimumSize( 10, 10 );
  label2->setMaximumSize( 32767, 32767 );
  label2->setText( "Y:" );
  label2->setAlignment( AlignLeft | AlignVCenter );
  label2->setMargin( -1 );

  QLabel* label4;
  label4 = new QLabel( this, "Label_4" );
  label4->setGeometry( 20, 130, 140, 30 );
  label4->setMinimumSize( 10, 10 );
  label4->setMaximumSize( 32767, 32767 );
  label4->setText( klocale->translate( "The sky:" ));
  label4->setAlignment( 289 );
  label4->setMargin( -1 );

  QLabel* label5;
  label5 = new QLabel( this, "Label_5" );
  label5->setGeometry( 20, 170, 140, 30 );
  label5->setMinimumSize( 10, 10 );
  label5->setMaximumSize( 32767, 32767 );
  label5->setText( klocale->translate( "The hell:" ));
  label5->setAlignment( 289 );
  label5->setMargin( -1 );

  QLabel* label6;
  label6 = new QLabel( this, "Label_6" );
  label6->setGeometry( 20, 210, 140, 30 );
  label6->setMinimumSize( 10, 10 );
  label6->setMaximumSize( 32767, 32767 );
  label6->setText( klocale->translate( "The ground:" ) );
  label6->setAlignment( 289 );
  label6->setMargin( -1 );

  QLabel* label7;
  label7 = new QLabel( this, "Label_7" );
  label7->setGeometry( 20, 250, 140, 30 );
  label7->setMinimumSize( 10, 10 );
  label7->setMaximumSize( 32767, 32767 );
  label7->setText( klocale->translate( "The small sphere:" ) );
  label7->setAlignment( 289 );
  label7->setMargin( -1 );

  QLabel* label8;
  label8 = new QLabel( this, "Label_8" );
  label8->setGeometry( 20, 290, 140, 30 );
  label8->setMinimumSize( 10, 10 );
  label8->setMaximumSize( 32767, 32767 );
  label8->setText( klocale->translate( "The big sphere:" ) );
  label8->setAlignment( 289 );
  label8->setMargin( -1 );

  ratioCheckbox = new QCheckBox( this, "CheckBox_1" );
  ratioCheckbox->setGeometry( 20, 85, 240, 20 );
  ratioCheckbox->setMinimumSize( 10, 10 );
  ratioCheckbox->setMaximumSize( 32767, 32767 );
  ratioCheckbox->setText( klocale->translate( "Keep 4:3 ratio" ) );
  ratioCheckbox->setAutoRepeat( FALSE );
  ratioCheckbox->setAutoResize( FALSE );
  ratioCheckbox->setChecked( true );

  QPushButton* dlgedit_PushButton_1;
  dlgedit_PushButton_1 = new QPushButton( this, "PushButton_1" );
  dlgedit_PushButton_1->setGeometry( 200, 340, 100, 30 );
  dlgedit_PushButton_1->setMinimumSize( 10, 10 );
  dlgedit_PushButton_1->setMaximumSize( 32767, 32767 );
  connect( dlgedit_PushButton_1, SIGNAL(clicked()), SLOT(generate()) );
  dlgedit_PushButton_1->setText( klocale->translate( "&Generate" ) );
  dlgedit_PushButton_1->setAutoRepeat( FALSE );
  dlgedit_PushButton_1->setAutoResize( FALSE );

  QPushButton* dlgedit_PushButton_2;
  dlgedit_PushButton_2 = new QPushButton( this, "PushButton_2" );
  dlgedit_PushButton_2->setGeometry( 10, 340, 70, 30 );
  dlgedit_PushButton_2->setMinimumSize( 10, 10 );
  dlgedit_PushButton_2->setMaximumSize( 32767, 32767 );
  connect( dlgedit_PushButton_2, SIGNAL(clicked()), SLOT(quit()) );
  dlgedit_PushButton_2->setText( klocale->translate( "Quit" ) );
  dlgedit_PushButton_2->setAutoRepeat( FALSE );
  dlgedit_PushButton_2->setAutoResize( FALSE );

  SkySurface = new QComboBox( FALSE, this, "ComboBox_7" );
  SkySurface->setGeometry( 180, 130, 110, 30 );
  SkySurface->setMinimumSize( 10, 10 );
  SkySurface->setMaximumSize( 32767, 32767 );
  SkySurface->setSizeLimit( 10 );
  SkySurface->setAutoResize( FALSE );
  SkySurface->insertItem( klocale->translate( "Sky" ) );
  SkySurface->insertItem( klocale->translate( "Hell" ) );
  SkySurface->insertItem( klocale->translate( "Simple Red" ) );
  SkySurface->insertItem( klocale->translate( "Simple Green" ) );

  HellSurface = new QComboBox( FALSE, this, "ComboBox_6" );
  HellSurface->setGeometry( 180, 170, 110, 30 );
  HellSurface->setMinimumSize( 10, 10 );
  HellSurface->setMaximumSize( 32767, 32767 );
  HellSurface->setSizeLimit( 10 );
  HellSurface->setAutoResize( FALSE );
  HellSurface->insertItem( klocale->translate( "Sky" ) );
  HellSurface->insertItem( klocale->translate( "Hell" ) );
  HellSurface->insertItem( klocale->translate( "Simple Red" ) );
  HellSurface->insertItem( klocale->translate( "Simple Green" ) );

  GroundSurface = new QComboBox( FALSE, this, "ComboBox_5" );
  GroundSurface->setGeometry( 180, 210, 110, 30 );
  GroundSurface->setMinimumSize( 10, 10 );
  GroundSurface->setMaximumSize( 32767, 32767 );
  GroundSurface->setSizeLimit( 10 );
  GroundSurface->setAutoResize( FALSE );
  GroundSurface->insertItem( klocale->translate( "Sky" ) );
  GroundSurface->insertItem( klocale->translate( "Hell" ) );
  GroundSurface->insertItem( klocale->translate( "Marble" ) );
  GroundSurface->insertItem( klocale->translate( "Water" ) );
  GroundSurface->insertItem( klocale->translate( "Glass" ) );
  GroundSurface->insertItem( klocale->translate( "Mirror" ) );
  GroundSurface->insertItem( klocale->translate( "Brass" ) );
  GroundSurface->insertItem( klocale->translate( "Simple Red" ) );
  GroundSurface->insertItem( klocale->translate( "Simple Green" ) );

  Sphere1Surface = new QComboBox( FALSE, this, "ComboBox_4" );
  Sphere1Surface->setGeometry( 180, 250, 110, 30 );
  Sphere1Surface->setMinimumSize( 10, 10 );
  Sphere1Surface->setMaximumSize( 32767, 32767 );
  Sphere1Surface->setSizeLimit( 10 );
  Sphere1Surface->setAutoResize( FALSE );
  Sphere1Surface->insertItem( klocale->translate( "Sky" ) );
  Sphere1Surface->insertItem( klocale->translate( "Hell" ) );
  Sphere1Surface->insertItem( klocale->translate( "Marble" ) );
  Sphere1Surface->insertItem( klocale->translate( "Water" ) );
  Sphere1Surface->insertItem( klocale->translate( "Glass" ) );
  Sphere1Surface->insertItem( klocale->translate( "Mirror" ) );
  Sphere1Surface->insertItem( klocale->translate( "Brass" ) );
  Sphere1Surface->insertItem( klocale->translate( "Simple Red" ) );
  Sphere1Surface->insertItem( klocale->translate( "Simple Green" ) );

  Sphere2Surface = new QComboBox( FALSE, this, "ComboBox_5" );
  Sphere2Surface->setGeometry( 180, 290, 110, 30 );
  Sphere2Surface->setMinimumSize( 10, 10 );
  Sphere2Surface->setMaximumSize( 32767, 32767 );
  Sphere2Surface->setSizeLimit( 10 );
  Sphere2Surface->setAutoResize( FALSE );
  Sphere2Surface->insertItem( klocale->translate( "Sky" ) );
  Sphere2Surface->insertItem( klocale->translate( "Hell" ) );
  Sphere2Surface->insertItem( klocale->translate( "Marble" ) );
  Sphere2Surface->insertItem( klocale->translate( "Water" ) );
  Sphere2Surface->insertItem( klocale->translate( "Glass" ) );
  Sphere2Surface->insertItem( klocale->translate( "Mirror" ) );
  Sphere2Surface->insertItem( klocale->translate( "Brass" ) );
  Sphere2Surface->insertItem( klocale->translate( "Simple Red" ) );
  Sphere2Surface->insertItem( klocale->translate( "Simple Green" ) );

  SkySurface->setCurrentItem(0);
  HellSurface->setCurrentItem(1);
  GroundSurface->setCurrentItem(3);
  Sphere1Surface->setCurrentItem(6);
  Sphere2Surface->setCurrentItem(2);
}






