/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef CONE
#define CONE

// label
#define ConeLabel "Cone"

// classes
#include <SFNode.h>
#include <SFFloat.h>
#include <SFBool.h>
#include <SFString.h>
#include <SFVec3f.h>

// class definition
class Cone : public SFNode {

public:

  // constructor
  Cone():SFNode(ConeLabel) {
    bottomRadius   = 1.0;
    height         = 2.0;
    side           = true;
    bottom         = true;
  }

  // destructor
  ~Cone() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);
    
  // render
  void render  (SFRenderInfo &);

  // operators
  Cone &operator    = (Cone &C2) {
    bottomRadius    = C2.bottomRadius;
    height          = C2.height;
    side            = C2.side;
    bottom          = C2.bottom;
    isValid()       = C2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data
  SFFloat  bottomRadius;
  SFFloat  height;
  SFBool   side;
  SFBool   bottom;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // Cone
