/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef INDEXEDLINESET
#define INDEXEDLINESET

// label
#define IndexedLineSetLabel "IndexedLineSet"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <MFInt32.h>
#include <Color.h>
#include <Coordinate.h>

// class definition
class IndexedLineSet : public SFNode {

public:

  // constructor
  IndexedLineSet() : SFNode(IndexedLineSetLabel) {
    colorPerVertex  = true;
  }

  // destructor
  ~IndexedLineSet() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode *);

  // operators
  IndexedLineSet &operator = (IndexedLineSet &I2) {
    color                  = I2.color;
    colorIndex             = I2.colorIndex;
    coord                  = I2.coord;
    coordIndex             = I2.coordIndex;
    colorPerVertex         = I2.colorPerVertex;
    isValid()              = I2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findUSE() {
    SFNode *MFN = (SFNode *) 0;
    if (unsatisfiedUSE()) {
      MFN = (SFNode *) this;
    } else {
      MFN = coord.findUSE();
      if (MFN == (SFNode *) 0) {
	coordIndex.findUSE();
	if (MFN == (SFNode *) 0) {return(MFN);    
	MFN = color.findUSE();
	}
      }
    }
    return(MFN);
  }
  SFNode *findDEF(SFString &UnsatUSE) {
    SFNode *MFN = (SFNode *) 0;
    if (UnsatUSE == DEF) {
      MFN = (SFNode *) this;
    } else {
      MFN = coord.findDEF(UnsatUSE);
      if (MFN == (SFNode *) 0) {
	coordIndex.findDEF(UnsatUSE);
	if (MFN == (SFNode *) 0) {
	  MFN = color.findDEF(UnsatUSE);
	}
      }
    }
    return(MFN);
  }
  SFString *use() {
    return(&USE);
  }

protected:


private:

  // data
  Coordinate coord;
  MFInt32    coordIndex;
  Color      color;
  MFInt32    colorIndex;
  SFBool     colorPerVertex;

  // USE-DEF
  SFString   DEF;
  SFString   USE;

};

#endif // IndexedLineSet
