/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef MFSTRING
#define MFSTRING

// label
#define MFStringLabel "MFString"

// classes
#include "SFNode.h"
#include "SFString.h"

// class definition
class MFString : public SFNode {

 public:

  // constructor
  MFString() : SFNode(MFStringLabel) {
    numElements = 0;
    data        = (SFString *) 0;
  }
  
  // destructor
  ~MFString() {
    if (data   != (SFString *) 0) delete[] data;    
    data        = (SFString *) 0;
    numElements = 0;
  }

  // parse
  void parse(char *, istream &);

  // operators
  MFString &operator = (MFString &M2) {
    alloc(M2.numElements);
    for (int i = 0; i < M2.numElements; i++) data[i] = M2.data[i];
    isValid()       = M2.isValid();
    return(*this);
  }
  SFString  & operator [] (int i) {
    if ((i < 0) || (i >= numElements)) {
      cerr << "\nError:\n";
      cerr << "\tOccurred in MFString::operator()\n";
      cerr << "\tOut of array bounds access (" << i << ")";
      cerr << " of (" << numElements << ")\n";
      exit(0);
    }
    return(data[i]);
  }

  // access
  int num() {
    return(numElements);
  }

  // allocate
  void alloc (int n) {
    numElements = n;
    data        = new SFString[n];
    if (data   == (SFString *) 0) {  
      cerr << "\nError:\n";
      cerr << "\tOccurred in MFString::alloc(" << n << ")\n";
      cerr << "\tCould not allocate requested memory\n";
      exit(0);
    }
  }
      
 protected:

 private:

  //  data
  int       numElements;
  SFString *data;

};

#endif // MFString





