/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFTIME
#define SFTIME

// label 
#define SFTimeLabel "SFTime"

// classes
#include <SFNode.h>

// class definition
class SFTime : public SFNode{

 public:

  // constructor
  SFTime() : SFNode(SFTimeLabel) {
    data = 0.0;
  }
  
  // destructor
  ~SFTime() {
  }

  // parse
  void parse(char *, istream &);

  // operators
  operator double () {
    return(data);
  }
  friend bool operator < (SFTime &t1, SFTime &t2) {
    return((double) t1 < (double) t2);
  }
  friend bool operator > (SFTime &t1, SFTime &t2) {
    return((double) t1 > (double) t2);
  }
  SFTime &operator += (double nt) {
    data += nt;
    return(*this);
  }
  SFTime &operator = (double nt) {
    data = nt;
    return(*this);
  }
  SFTime &operator = (SFTime &nt) {
    data           = nt;
    return(*this);
  }

 protected:

 private:

  // data
  double data;

};

#endif // SFTime
