/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef SPOTLIGHT
#define SPOTLIGHT

// label
#define SpotLightLabel "SpotLight"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFFloat.h>
#include <SFVec3f.h>
#include <SFColor.h>
#include <SFInt32.h>
#include <SFString.h>

// class definition
class SpotLight : public SFNode {

 public:

  // constructor
  SpotLight() : SFNode(SpotLightLabel) {
    on               =  true;
    intensity        =  1.0;
    ambientIntensity =  0.0;
    color[0]         =  1.0;
    color[1]         =  1.0;
    color[2]         =  1.0;
    location[0]      =  0.0;
    location[1]      =  0.0;
    location[2]      =  0.0;
    direction[0]     =  0.0;
    direction[1]     =  0.0;
    direction[2]     = -1.0;
    beamWidth        =  1.570796;
    cutOffAngle      =  0.785398;
    radius           =  100;
    attenuation[0]   =  1;
    attenuation[1]   =  0;
    attenuation[2]   =  0;
  }

  // destructor
  ~SpotLight() {
  }
  
  // parse
  void parse   (char         *,  istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode  *);

  // operators
  SpotLight &operator = (SpotLight &S2) {
    location          = S2.location;
    direction         = S2.direction;
    beamWidth         = S2.beamWidth;
    cutOffAngle       = S2.cutOffAngle;
    radius            = S2.radius;
    attenuation       = S2.attenuation;
    on                = S2.on;
    intensity         = S2.intensity;
    ambientIntensity  = S2.ambientIntensity;
    color             = S2.color;
    isValid()         = S2.isValid(); 
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFVec3f  location;
  SFVec3f  direction;
  SFFloat  beamWidth;
  SFFloat  cutOffAngle;
  SFFloat  radius;
  SFVec3f  attenuation;
  SFBool   on;
  SFFloat  intensity;
  SFFloat  ambientIntensity;
  SFColor  color;
   
  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // SpotLight

