/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef DrawingArea_included
#define DrawingArea_included

/* for opengl info */
#include <qgl.h>

/* for information about classes */
#include <Children.h>
#include <Viewpoint.h>
#include <Background.h>
#include <SFRenderInfo.h>
#include <Fog.h>

class DrawingArea : public QGLWidget
{
  Q_OBJECT
    
    public:

  // constructor
  DrawingArea(QWidget* parent = NULL, const char* name = NULL);
  
  // destructor
  ~DrawingArea() {
  }

  // access private data
  SFNode* &node() {
    return(privateNode);
  }

  // initialize the call list
  void Initialize(char       *FN,
		  QPopupMenu *ExposedEvents,
		  QPopupMenu *SensorEvents);

  // does the resize
  void resizeGL(int w, int h); 

  // the type of navigation
  enum NavigationType{ExamineView=1, WalkView=2, FlyView=3, NoneView=4};

  /* repaints the scence */
  void paintGL();

  /* create a time step event */
  void GenerateTimeEvent();

 public slots:

 protected slots:

  // mouse movement events
  void  mouseMoveEvent (QMouseEvent *QME);
  void  mousePressEvent(QMouseEvent *QME);

  /* for bindables */
  void slotSetNavigation(int n);
  void slotSetView      (int n);
  void slotSetFog       (int n);
  void slotSetBack      (int n);

  /* for sensors */
  void slotTouchSensorEvent(int n);
  void slotTimeSensorEvent(int n);
  void slotVisibilitySensorEvent(int n);
  void slotSphereSensorEvent(int n);
  void slotProximitySensorEvent(int n);
  void slotPlaneSensorEvent(int n);
  void slotCylinderSensorEvent(int n);

 protected:

  /* initialize various exposed field events */
  void InitializeViewpoints(QPopupMenu *events);

  /* initialize the various sensor events */
  void InitializeSensors(Children   &stack, 
			 char       *label,
			 QPopupMenu *menu,
			 QPopupMenu *events,
			 char       *slot);

  /* a generate sensor event */
  void SensorEvent      (Children   &stack,
			 int         n);

 private:

  /* the pose parameters associated with the mouse */
  float AzPose;
  float ElPose;

  /* the translation */
  float TxPose;
  float TyPose;
  float TzPose; 

  /* the current mouse value */
  int MouseX;
  int MouseY;

  /* the scene graph */
  SFNode *privateNode;

  /* the type of navigation to perform */
  NavigationType privateNavigationType;

  /* stacks for the bindable nodes */
  Children *privateViewpoints;
  Children  privateBackgrounds;
  Children *privateFogs;

  /* the current bound node */
  Viewpoint  *privateBoundViewpoint;
  Fog        *privateBoundFog;

  /* the sensor stacks */
  Children   visibilitySensorStack;
  Children   touchSensorStack;
  Children   timeSensorStack;
  Children   sphereSensorStack;
  Children   proximitySensorStack;
  Children   planeSensorStack;
  Children   cylinderSensorStack;

  /* the bindables */
  QPopupMenu *privateNav;
  QPopupMenu *privateBack;
  QPopupMenu *privateFog;
  QPopupMenu *privateView;

  /* the sensors */
  QPopupMenu *privateVisibilitySensorMenu;
  QPopupMenu *privateTouchSensorMenu;
  QPopupMenu *privateTimeSensorMenu;
  QPopupMenu *privateSphereSensorMenu;
  QPopupMenu *privateProximitySensorMenu;
  QPopupMenu *privatePlaneSensorMenu;
  QPopupMenu *privateCylinderSensorMenu;

  /* the render information struct */
  SFRenderInfo SFRI;

};

#endif // DrawingArea_included


