/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef VrmlViewer_included
#define VrmlViewer_included

/* local dialog */
#include <qdialog.h>
#include <qmenubar.h>
#include <qtimer.h>

/* keyboard configuration */
#include <kstdaccel.h>
#include <ktoolbar.h>
#include <ktopwidget.h>
#include <kapp.h>
#include <klocale.h>

/* local classes */
#include "DrawingArea.h"

class VrmlViewer : public KTopLevelWidget
{
  Q_OBJECT
    
public:
  
  // constructor
  VrmlViewer();
  VrmlViewer(char *FN);
  
  // destructor
  virtual ~VrmlViewer();

public slots:
        
protected slots:

  /* actions for the pulldown menus */
  void slotAbout();
  void slotHelp();
  void slotHelpKDE();
  void slotHelpQt();

  /* exit the application */
  void slotQuit();

  /* for animation */
  void slotSingleTimeStep();
  void slotDoubleTimeStep();
  void slotStopTimeStep();

  /* for navigational info */
  void slotFly();

  /* change background color */
  void slotSetBackgroundColor();

  /* adapts the mouse sensitivity */
  void slotLoadFile();
 
protected:

  /* create the interface */
  void CreateInterface();

  /* set up the pull down menus */
  void InitializeFileMenu();
  void InitializeOptionsMenu();
  void InitializeEventsMenu();
  void InitializeHelpMenu();

  /* the internal widgets */
  KMenuBar     *protectedMenuBar;
  DrawingArea  *protectedViewer;

  /* for keyboard configuration */
  KConfig      *config;
  KStdAccel    *accel;

private:

  /* the various sensor events */
  QPopupMenu *privateSensorEvents;
  QPopupMenu *privateExposeEvents;

  /* the background color */
  QColor      backColor;

  /* to time events */
  bool        continuousAnimation;

};

#endif // VrmlViewer_included



