/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <SFString.h>
#include <SFEvent.h>
#include <TouchSensor.h>
#include <Children.h>

/*************************************************************************/
void TouchSensor::eventOut(SFString &, SFNode *)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered TouchSensor::eventsOut(" << DEF << ")\n";
#endif 

  /* if no events need to be generated we are done */
  if (eventQueue() == (Children *) 0) return;

  /* generate any appropriate cascading events */
  for (Children *C = eventQueue(); C != (Children *) 0; C = C->next()) {

    /* do not process incomplete nodes */
    if (C->data() == (SFNode *) 0) continue;

    /* determine the event */
    SFEvent *event = (SFEvent *) C->data();

    /* determine the appropriate event to generate */
    if (event->to() == (SFNode *) 0) continue;

    /* generate the event */
    if (event->eventFromName() == "isActive") {
      event->to()->eventIn(event->eventToName(), &(isActive));
    }
  }

}
/*************************************************************************/

/*************************************************************************/
void TouchSensor::eventIn(SFString &eventType, SFNode *eventData)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered TouchSensor::eventsIn (" << DEF << ")\n";
#endif 

  /* based on the input event choose an appropriate action */
  if ((eventType == "enabled") || (eventType == "set_enabled")) {
    SFBool *n = (SFBool *) eventData;
    enabled = *n;
  }

  /* we are active */
  isActive = true;

  /* cascade outgoing events */
  SFString out = "isActive";
  eventOut(out, &(isActive));


}
/*************************************************************************/

/*************************************************************************/
void TouchSensor::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* the required labels */
  bool TokenFound  = false;
  bool BeginBracketFound   = false;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    Token.GetToken(InFile);

#ifdef DEBUG_PARSE
    cout << "\tTouchSensor: (" << Token() << ")\n";
#endif

    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token == "enabled") {
      enabled.parse(header, InFile);

    } else if (Token == "TouchSensor") {
      TokenFound = true;

    } else if (Token == "{") {
      BeginBracketFound = true;

    } else if (Token == "}") {
      break;
      
    } else {
      parseWarning(Token());

    }
  }

  /* if we did not find the material token we are in trouble */
  if (TokenFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected identifier token.\n";
    exit(0);
  }
  if (BeginBracketFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected \"{\" token.\n";
    exit(0);
  }
}
/*************************************************************************/

