#include <qapplication.h>
#include <qlistview.h>
#include <qpixmap.h>
#include <qcolor.h>

class Draggable : public QListView
{
public:
  Draggable();
  virtual ~Draggable();

protected:
  virtual void mousePressEvent(QMouseEvent *e);
  virtual void mouseMoveEvent(QMouseEvent *e);
  virtual void mouseReleaseEvent(QMouseEvent *e);
  virtual void startDrag(QListViewItem *item);
  virtual void maybeTarget(QListViewItem *item);
  virtual void finishDrag(QListViewItem *target);

  bool maybeDragging_;
  bool dragging_;
  QPoint dragStart_;
  QListViewItem *dragItem;
  QPixmap dragPix;
};

Draggable::Draggable()
  : QListView(0, "Drag test")
{
  maybeDragging_= false;
  dragging_= false;
  dragItem= 0;
}

Draggable::~Draggable()
{

}

void Draggable::mousePressEvent(QMouseEvent *e)
{
  QListView::mousePressEvent(e);
  maybeDragging_= true;
  dragStart_= e->pos();
  dragItem= itemAt(e->pos());

  warning("may be");
}

void Draggable::mouseMoveEvent(QMouseEvent *e)
{
  if (maybeDragging_ && (!dragging_)) {
    int sx= dragStart_.x();
    int sy= dragStart_.y();
    int x= e->x();
    int y= e->y();

    int dsq= (x-sx) * (x-sx) + (y-sy) * (y-sy);

    warning("dist %d\n", dsq);
    if (dsq > 64) {
      /* && dist > threshold */
      dragging_= true;
      startDrag(dragItem);
      warning("dragging");
    }
  }
  else {
    maybeTarget(itemAt(e->pos()));
  }
}

void Draggable::startDrag(QListViewItem *item)
{
  QPixmap pix(20, 20);
  pix.fill(green);
  dragPix= pix;

  QApplication::setOverrideCursor(crossCursor);
}

void Draggable::maybeTarget(QListViewItem *target)
{
  if (!target) {
    QApplication::restoreOverrideCursor();
    QApplication::setOverrideCursor(waitCursor);
  }
  else {
    QApplication::restoreOverrideCursor();
    QApplication::setOverrideCursor(crossCursor);
  }
}

void Draggable::finishDrag(QListViewItem *target)
{
  QApplication::restoreOverrideCursor();

  warning("target= %p", target);
}

void Draggable::mouseReleaseEvent(QMouseEvent *e)
{
  QListView::mouseReleaseEvent(e);
  maybeDragging_= false;

  if (dragging_) {
    finishDrag(itemAt(e->pos()));
    dragging_= false;
    warning("done");
  }
}

int main(int argc, char **argv)
{
  QApplication qapp(argc, argv);
  QListView *lv= new Draggable();
  lv->addColumn("Crap");

  QListViewItem *i= new QListViewItem(lv);
  i->setText(0, "blah");
  QListViewItem *i2= new QListViewItem(lv);
  i2->setText(0, "blah");

  qapp.connect(&qapp, SIGNAL(lastWindowClosed()), &qapp, SLOT(quit()));

  lv->show();
  return qapp.exec();
}
