/***************************************************************************
                          formcomponent.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Mar 21 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qwidget.h>
#include <qlayout.h>

#include "formcomponent.h"
#include "instance.h"
#include "enumvalue.h"
#include "intvalue.h"

#define COMPONENT_NAME "Form"
#define COMPONENT_DESC "A basic form widget"

FormComponent::FormComponent()
	: Component(COMPONENT_NAME, COMPONENT_DESC)
{
}

FormComponent::~FormComponent()
{
}

Instance *FormComponent::createInstance(Instance *parent)
{
	warning("Creating Form Instance");

	Instance *fi= new Instance(this, parent);
	
	EnumValue *ev= new EnumValue();
	ev->addValue("Horizontal", QBoxLayout::LeftToRight);
	ev->addValue("Vertical", QBoxLayout::TopToBottom);
	fi->addProperty("Orientation", ev);
	
	IntValue *iv= new IntValue();
	iv->setValue(5);
	fi->addProperty("Spacing", iv);
	
	return fi;
}

QWidget *FormComponent::createView(Instance *props, QWidget *parent)
{
	ASSERT(parent);
	ASSERT(props);

	warning("FormComponent::createView()");

	QWidget *view= new QWidget(parent);
	CHECK_PTR(view);
	
	// view->resize(100, 100);
	// QWidget *view= parent;

	EnumValue *ev= (EnumValue *) props->get("Orientation");
	IntValue *iv= (IntValue *) props->get("Spacing");

	QBoxLayout *box= new QBoxLayout(view, (QBoxLayout::Direction) ev->toInt(), iv->value());
	
	for (uint i= 0; i < props->childCount(); i++) {
		warning("++ Creating child %d", i);
		
		// Handle the top child
		Instance *child= props->getChild(i);
	
		// Recurse into the child's createView() method
		QWidget *childView= child->createView(view);
		
		if (!childView) {
			warning("Failed to create child %d", i);
		}
		else {
			box->addWidget(childView);
		}		
	}	
	
	//	updateView(props, view);
	box->activate();
	
	return view;
}

void FormComponent::updateView(Instance *props, QWidget *view)
{
	ASSERT(view);
	ASSERT(props);

	for (uint i= 0; i < props->childCount(); i++) {
		warning("++ Creating child %d", i);
		
		// Handle the top child
		Instance *child= props->getChild(i);
	
		// Recurse into the child's createView() method
		QWidget *childView= child->updateView(view);
		
		if (!childView) {
			warning("FormComponent::updateView() received null childView");
		}
	}
}





















