/***************************************************************************
                          instance.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Mar 18 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "instance.h"
#include "component.h"

Instance::Instance(Component *comp, Instance *parent)
	:	QObject(),
		properties(),
		name_("Unspecified")
{
	component_= comp;
	children.setAutoDelete(true);
	
	setParent(parent);
	
	if (parent)
		parent->addChild(this);
	else
		parent_= 0;
}

Instance::~Instance()
{
}

uint Instance::propertyCount()
{
	return propertyNames_.count();
}

const char *Instance::propertyName(uint n)
{
	return propertyNames_.at(n);
}

void Instance::addProperty(const char *name, Value *value)
{
	propertyNames_.append(name);
	set(name, value);
}

Value *Instance::get(const char *name)
{
	return properties[name];
}

void Instance::set(const char *name, Value *value)
{
	properties.insert(name, value);
}

Component *Instance::component()
{
	return component_;
}

QWidget *Instance::createView(QWidget *parent)
{
	warning("Instance::createView() [%s]", name_.data());

	return component_->createView(this, parent);
}

QWidget *Instance::updateView(QWidget *parent)
{
	warning("Instance::updateView() [%s]", name_.data());

	component_->updateView(this, parent);
	return parent;
}

Instance *Instance::parent()
{
	return parent_;
}

void Instance::setParent(Instance *parent)
{
	parent_= parent;
}

void Instance::insertChild(uint index, Instance *child)
{
	child->setParent(this);
	children.insert(index, child);
}

void Instance::addChild(Instance *child)
{
	child->setParent(this);
	children.append(child);
}

void Instance::removeChild(uint index)
{
	children.at(index)->setParent(0);
	children.remove(index);
}

int Instance::findChild(Instance *child)
{
	return children.findRef(child);
}

Instance *Instance::takeChild(uint index)
{
	return children.take(index);
}

Instance *Instance::getChild(uint n)
{
	return children.at(n);
}

uint Instance::childCount()
{
	return children.count();
}

const char *Instance::name()
{
	return name_.data();
}

void Instance::setName(const char *newname)
{
	name_= newname;
}
































