/***************************************************************************
                          instance.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 18 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef INSTANCE_H
#define INSTANCE_H

#include <qobject.h>
#include <qdict.h>
#include <qstrlist.h>

#include "value.h"

class QWidget;

/**
	* Represents an instance of either a QWidget or a QLayout subclass.
	*
  * @author Richard Moore
  */
class Instance : public QObject
{
public: 
	Instance(class Component *comp, Instance *parent= 0);
	virtual ~Instance();

	/**
		* Set the name of the Instance.
		*/
	void setName(const char *name);

	/**
		* Get the name of the Instance.
		*/
	const char *name();

	/**
		* The number of properties defined for this instance.
		*/
	uint propertyCount();
	const char *propertyName(uint n);
	/**
		* Adds a new property with the specified Value and name.
		*/
	void addProperty(const char *, Value *);
	
	/**
		* Get the value of the specified property.
		*/
	Value *get(const char *);
	
	/**
		* Set the specified property to the specified Value.
		*/
	void set(const char *, Value *);
	
	/**
		* Get the component this is an instance of.
		*/
	virtual class Component *component();
	
	/**
		* Forwarded to the createView() method of the relevent Component.
		*/
	virtual QWidget *createView(QWidget *parent);
	
	/**
		* Forwarded to the updateView() method of the relevent Component.
		*/
	virtual QWidget *updateView(QWidget *parent);
	class Instance *parent();
	void setParent(Instance *parent);

	uint childCount();
	virtual void addChild(Instance *child);
	virtual void insertChild(uint index, Instance *child);
	virtual void removeChild(uint index);
	virtual Instance *getChild(uint index);
	virtual Instance *takeChild(uint index);
	virtual int findChild(Instance *);

protected:
	class Component *component_;
	QDict <Value> properties;
	QStrList propertyNames_;
	QList <Instance> children;
	Instance *parent_;
	QString name_;
};

#endif































