/***************************************************************************
                          kgui.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Mar 15 23:42:04 GMT 1999
                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <kgui.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qtoolbutton.h>
#include "global.h"


KGUIApp::KGUIApp()
{
  setCaption("KGUI " VERSION);

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initView();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!bViewToolbar)
    enableToolBar(KToolBar::Hide,0);
  if (!bViewStatusbar)
    enableStatusBar(KStatusBar::Hide);

  menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup

}

KGUIApp::~KGUIApp()
{
  
}

void KGUIApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KGUIApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}


void KGUIApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertItem(Icon("mini/kguiapp.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW );
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"), ID_FILE_SAVE );
  file_menu->insertItem(i18n("Save &as"), ID_FILE_SAVE_AS );
  file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print"), ID_FILE_PRINT );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("C&lose Window"), ID_FILE_CLOSE_WINDOW);
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );

  // file_menu key accelerators
  file_menu->setAccel(CTRL+Key_N, ID_FILE_NEW);
  file_menu->setAccel(CTRL+Key_O, ID_FILE_OPEN);
  file_menu->setAccel(CTRL+Key_S, ID_FILE_SAVE);
  file_menu->setAccel(CTRL+Key_W, ID_FILE_CLOSE);
  file_menu->setAccel(CTRL+Key_P, ID_FILE_PRINT);
  file_menu->setAccel(CTRL+Key_Q, ID_FILE_QUIT);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  edit_menu = new QPopupMenu();
  edit_menu->insertItem(Icon("editcut.xpm"), i18n("Cu&t"), ID_EDIT_CUT );
  edit_menu->insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_EDIT_COPY );
  edit_menu->insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_EDIT_PASTE );
 
  //edit_menu key accelerators
  edit_menu->setAccel(CTRL+Key_X, ID_EDIT_CUT);
  edit_menu->setAccel(CTRL+Key_C, ID_EDIT_COPY);
  edit_menu->setAccel(CTRL+Key_V, ID_EDIT_PASTE);

 
  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  insertMenu= Global::getComponentManager()->createInsertPopup();

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Edit"), edit_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
	menuBar()->insertItem(i18n("&Insert"), insertMenu);


  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu);
  CONNECT_CMD(edit_menu);
  CONNECT_CMD(view_menu);

  connect(insertMenu, SIGNAL(activated(int)), SLOT(insertCommandCallback(int)));
  connect(insertMenu, SIGNAL(highlighted(int)), SLOT(insertStatusCallback(int)));
}

void KGUIApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New File"));
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open File"));
  toolBar()->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE, true, i18n("Save File"));
  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("editcut.xpm"), ID_EDIT_CUT, true, i18n("Cut"));
  toolBar()->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy"));
  toolBar()->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP, SIGNAL(pressed()), kapp, SLOT(appHelpActivated()), true, i18n("Help"));

	// Add a What's this button to the standard toolbar
	#if 1
	
	QToolButton *whatsThisButton= QWhatsThis::whatsThisButton(toolBar());
	QToolTip::add(whatsThisButton, i18n("What's this?") );
	
	QWhatsThis::add(whatsThisButton, i18n("After pressing this button click on part of the application to see it's description.") );
	
	toolBar()->insertWidget(ID_HELP_WHATS_THIS,
													whatsThisButton->sizeHint().width(),
													whatsThisButton);
	#endif

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
  // add functionality for new created toolbars in:
  // enableCommand, disableCommand, in the menuBar() and an additional function slotViewToolbar_1
  // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
  // Also update resource values and commands 


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  CONNECT_TOOLBAR(toolBar());

}

void KGUIApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);

}

void KGUIApp::initView()
{
  doc = new KGUIDoc(this);
	
  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  KApplication *app=KApplication::getKApplication();
  view = new KGUIView(app,doc,this);
  setView(view);

}

bool KGUIApp::queryExit()
{
  int exit=KMsgBox::yesNo(this, i18n("Exit"), i18n("Really Quit ?"));

  if(exit==1)
    return true;
  else
    return false;
}

void KGUIApp::saveOptions()
{
  KConfig *config = kapp->getConfig();


  config->setGroup("APPEARANCE");
  config->writeEntry("ShowToolbar",toolBar()->isVisible());
  config->writeEntry("ShowStatusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());

}

void KGUIApp::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();

 
  config->setGroup("APPEARANCE");
  bViewToolbar = config->readBoolEntry("ShowToolbar", true);
  bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top); 
  tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);

}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KGUIApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
  (new KGUIApp)->show();
  slotStatusMsg(IDS_DEFAULT);
}

void KGUIApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new file..."));

  slotStatusMsg(IDS_DEFAULT);
}

void KGUIApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));

  slotStatusMsg(IDS_DEFAULT);
}


void KGUIApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving file..."));

  slotStatusMsg(IDS_DEFAULT);
}

void KGUIApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving file under new filename..."));

  slotStatusMsg(IDS_DEFAULT);
}

void KGUIApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));

  slotStatusMsg(IDS_DEFAULT);
}

void KGUIApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this))
    {
      QPainter painter;
      painter.begin( &printer );

      ///////////////////////////////////////////////////////////////////
      // TODO: Define printing by using the QPainter methods here

      painter.end();
    };

  slotStatusMsg(IDS_DEFAULT);
}

void KGUIApp::slotFileCloseWindow()
{
  close();
}
void KGUIApp::slotFileQuit()
{ 

  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(this->queryExit())
    {
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
    }
  else
    slotStatusMsg(IDS_DEFAULT);
    return;
}

void KGUIApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));

  slotStatusMsg(IDS_DEFAULT);
}

void KGUIApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to Clipboard..."));

  slotStatusMsg(IDS_DEFAULT);
}

void KGUIApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting Clipboard contents..."));

  slotStatusMsg(IDS_DEFAULT);
}

void KGUIApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  bViewToolbar=!bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);

}

void KGUIApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


void KGUIApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KGUIApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void KGUIApp::commandCallback(int id_){
  switch (id_){
    ON_CMD(ID_FILE_NEW_WINDOW,          slotFileNewWindow())
    ON_CMD(ID_FILE_NEW,                 slotFileNew())
    ON_CMD(ID_FILE_OPEN,                slotFileOpen())
    ON_CMD(ID_FILE_SAVE,                slotFileSave())
    ON_CMD(ID_FILE_SAVE_AS,             slotFileSaveAs())
    ON_CMD(ID_FILE_CLOSE,               slotFileClose())
    ON_CMD(ID_FILE_PRINT,               slotFilePrint())
    ON_CMD(ID_FILE_CLOSE_WINDOW,        slotFileCloseWindow())
    ON_CMD(ID_FILE_QUIT,                slotFileQuit())

    ON_CMD(ID_EDIT_CUT,                 slotEditCut())
    ON_CMD(ID_EDIT_COPY,                slotEditCopy())
    ON_CMD(ID_EDIT_PASTE,               slotEditPaste())
  
    ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
    ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())
  }
}

void KGUIApp::insertCommandCallback(int id)
{
	warning("insertCommandCallback(%d)", id);

	ComponentManager *cm= Global::getComponentManager();
	
	Component *c= cm->component(id);
	if (c) {
		view->document()->insert(c);
	}
}

void KGUIApp::insertStatusCallback(int id)
{
	ComponentManager *cm= Global::getComponentManager();
	
	Package *p= cm->packageFromId(id);
	if (p) {
		Component *c= cm->component(id);
		if (c) {
			slotStatusHelpMsg(c->description());
		}
		else {
			slotStatusHelpMsg(p->description());		
		}		
	}
}


void KGUIApp::statusCallback(int id_){
  switch (id_){
    ON_STATUS_MSG(ID_FILE_NEW_WINDOW,   i18n("Opens a new application window"))
    ON_STATUS_MSG(ID_FILE_NEW,          i18n("Creates a new document"))
    ON_STATUS_MSG(ID_FILE_OPEN,         i18n("Opens an existing document"))
    ON_STATUS_MSG(ID_FILE_SAVE,         i18n("Save the actual document"))
    ON_STATUS_MSG(ID_FILE_SAVE_AS,      i18n("Save the document as..."))
    ON_STATUS_MSG(ID_FILE_CLOSE,        i18n("Closes the actual file"))
    ON_STATUS_MSG(ID_FILE_PRINT,        i18n("Prints the current document"))
    ON_STATUS_MSG(ID_FILE_CLOSE_WINDOW, i18n("Closes the current window"))
    ON_STATUS_MSG(ID_FILE_QUIT,         i18n("Exits the program"))

    ON_STATUS_MSG(ID_EDIT_CUT,          i18n("Cuts the selected section and puts it to the clipboard"))
    ON_STATUS_MSG(ID_EDIT_COPY,         i18n("Copys the selected section to the clipboard"))
    ON_STATUS_MSG(ID_EDIT_PASTE,        i18n("Pastes the clipboard contents to actual position"))
    ON_STATUS_MSG(ID_EDIT_SELECT_ALL,   i18n("Selects the whole document contents"))


    ON_STATUS_MSG(ID_VIEW_TOOLBAR,      i18n("Enables / disables the actual Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATUSBAR,    i18n("Enables / disables the Statusbar"))
  }
}














































