/***************************************************************************
                          stringvalue.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Mar 19 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include "stringvalue.h"
#include "stringvalueeditor.h"

StringValue::StringValue()
	: text_()
{
	text_= "A string";
}

StringValue::~StringValue()
{
}


ValueEditor *StringValue::createEditor(QWidget *parent)
{
	ValueEditor *frame= new StringValueEditor(parent, "String editor", this);
	CHECK_PTR(frame);

	return frame;
}

const char *StringValue::toString()
{
	return text_.data();
}

void StringValue::fromString(const char *str)
{
	ASSERT(str);

	text_= str;
}














