/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the Visual 'K' project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef VKSUBWS
#define VKSUBWS

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qstring.h>
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kprocess.h>

/*****************************************************************************
	The following classes are reimplementations of Qt widgets.
	I extended them by some _small_ things, like extra signals ...
******************************************************************************/
class vkPushButton : public QPushButton
{
	Q_OBJECT

public:
	vkPushButton( QWidget *parent, const char *name = 0L );
};

class vkLabel : public QLabel
{
	Q_OBJECT

public:
	vkLabel( QWidget *parent, const char *name = 0L );

signals:
	void clicked();

private:
	virtual void mouseReleaseEvent( QMouseEvent * );

};

class vkPixLabel : public QLabel
{
	Q_OBJECT

public:
	vkPixLabel( QWidget *parent, const char *name = 0L );

	QString pixName() { return pixy; } // not implemented, yet

	void loadPic( QString );

signals:
	void clicked();

private:
	virtual void mouseReleaseEvent( QMouseEvent * );
	QString pixy;

};

class vkLineEdit : public QLineEdit
{
	Q_OBJECT

public:
	vkLineEdit( QWidget *parent, const char *name = 0L );

signals:
	void changed();

};

class vkListBox : public QListBox
{
	Q_OBJECT

public:
	vkListBox( QWidget *parent, const char *name = 0L );

	void setAutoSort(bool){}
	bool isSorted(){return true;}

signals:
	void changed();

};

class vkCheckBox : public QCheckBox
{
	Q_OBJECT

public:
	vkCheckBox( QWidget *parent, const char *name = 0L );
};

class vkOptionButton : public QRadioButton
{
	Q_OBJECT

public:
	vkOptionButton( QWidget *parent, const char *name = 0L );

signals:
	void uncheckOpts();

private slots:
	void click();

};

class vkSlider : public QSlider
{
	Q_OBJECT

public:
	vkSlider( QWidget *parent, const char *name = 0L );

signals:
	void changed();
};

class vkProcCtrl : public QLabel
{
	Q_OBJECT

public:
	vkProcCtrl( QWidget *parent, const char *name = 0L );

	virtual QString commandName() { return cmd; }
	virtual QString commandArgs() { return args; }

	bool isRunning();
	int ret();

	void setCommand(QString);
	void setArgs(QString);

	void setRunning(bool);

	void ts( QString );

signals:
	void changed();
	void exited();

private:
	void setAllArgs();

	QString cmd;
	QString args;
	bool hasStarted;

	KProcess *kp;

private slots:
	void gotOut( KProcess *, char *, int );
	void kpexit( KProcess * );
};

#endif