/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "scan.h"

char *scanstr;
int sptr;

struct poplist
{
	char *word;
	struct poplist *next;
};

struct poplist *pops = 0L;

void start( char *str )
{
struct poplist *tmppop;

	scanstr = str;
	sptr = 0;

	while( pops != 0L )
	{
		tmppop = pops;
		pops = pops->next;
		free(tmppop->word);
		free(tmppop);
	}

	activeLine = 1;
}

void push( char *newWord )
{
struct poplist *newEntry;
int i;

	newEntry = (struct poplist *) malloc( sizeof(struct poplist) );

	newEntry->word = (char *) malloc( strlen(newWord)+1 );

	if (pops == 0L)
		newEntry->next = 0L;
	else
		newEntry->next = pops;

	pops = newEntry;

	i = 0;

	do
	{
		newEntry->word[i] = newWord[i];
		i++;
	} while( newWord[i] != 0L );

	newEntry->word[i] = 0L;
}

void eatWhite()
{
int i = -1;

	while( i != sptr )
	{
		i = sptr;

		while( scanstr[sptr] == ' ' || scanstr[sptr] == '\t'
			|| scanstr[sptr] == '\n' )
		{
			if( scanstr[sptr] == '\n' )
				activeLine++;

			sptr++;
		}

		if( scanstr[sptr] == '#' )
			while( scanstr[sptr] != '\n' ) sptr++;
	}

}

int lowCheck( char *a, char *b )
{
int i = 0;


	while( a[i] != 0L && b[i] != 0 )
	{
		if( tolower(a[i]) != tolower(b[i]) )
			return 0;

		i++;
	}

	if( a[i] != 0L || b[i] != 0L )
		return 0;
	else
		return 1; //Same length and no difference
}

int scanny()
{
char word[512] = "";
int i = 0;
int start;

	/*first, eat up all white-space before looking for the token:*/
	eatWhite();

	start = sptr;

	if( scanstr[sptr] == 0L )
		return EOFI;
	else if( scanstr[sptr] == '"' )
	{ /* String */

		do
		{
			if( scanstr[sptr] == 0L )
				return ERR;

			word[i] = scanstr[sptr];
			i++;
			sptr++;

		} while( scanstr[sptr] != '"' );

		sptr++;

		word[i] = '"';

		word[i+1] = 0L;

		push(word);

		return VALUE;

	}
	else if( scanstr[sptr] == '=' )
	{
		strcpy( word, "=" );
		sptr++;
		push(word);
		return SET;
	}
	else if( scanstr[sptr] == ':' )
	{
		strcpy( word, ":" );
		sptr++;
		push(word);
		return DBLP;
	}
	else if( scanstr[sptr] == ';' )
	{
		strcpy( word, ";" );
		sptr++;
		push(word);
		return SCOL;
	}
	else if( scanstr[sptr] == '(' )
	{
		strcpy( word, "(" );
		sptr++;
		push(word);
		return PARA;
	}
	else if( scanstr[sptr] == ')' )
	{
		strcpy( word, ")" );
		sptr++;
		push(word);
		return PARB;
	}
	else if( isdigit(scanstr[sptr]) )
	{
		while( isdigit(scanstr[sptr]) )
		{
			word[i] = scanstr[sptr];
			i++; sptr++;
		}

		word[i] = 0L;

		push(word);

		return ARGNUM;
	}
	else if( isalpha(scanstr[sptr]) )
	{

		while( isalnum(scanstr[sptr]) || scanstr[sptr] == '.' )
		{
			word[i] = scanstr[sptr];
			i++; sptr++;
		}


		word[i] = 0L;

		push(word);

		if( lowCheck( word, "Window" ) || lowCheck( word, "SubWindow" ) )
			return WINDOW;

		if( lowCheck( word, "Properties" ) )
			return PROPS;

		if( lowCheck( word, "Regional" ) || lowCheck( word, "Variables" ) )
			return VARS;

		if( lowCheck( word, "RegConst" ) || lowCheck( word, "Consts" ) )
			return CONSTS;

		if( lowCheck( word, "Functions" ) )
			return FUNCS;

		if( lowCheck( word, "SubWidgets" ) || lowCheck( word, "Widgets" ) )
			return OBJECTS;

		if( lowCheck( word, "Button" )
			|| lowCheck( word, "Label" )
			|| lowCheck( word, "PixLabel" )
			|| lowCheck( word, "LineEdit" )
			|| lowCheck( word, "ListBox" )
			|| lowCheck( word, "CheckBox" )
			|| lowCheck( word, "OptionButton" )
			|| lowCheck( word, "Slider" )
			|| lowCheck( word, "ProcCtrl" ) )
				return TYPE;

		if( lowCheck( word, "Project" ) )
			return PROJECT;

		if( lowCheck( word, "Globals" ) )
			return GLOBALS;

		return NAME;
	}
	else
		return ERR;


}

int next()
{
int ret;

	ret = scanny();

	if( ret == ERR )
	{
		printf( "vkConfigmaker: in file %s: Scanner error.\n", f_name );
		exit(2);
	}

	return ret;
}

char *pop()
{
struct poplist *tmppop;
char *ret;

	if ( pops == 0L )
	{
		printf( "vkConfigmaker: INTERNAL ERROR: Nothing on the stack.\n" );
		abort();
	}

	ret = pops->word;

	tmppop = pops;
	pops = pops->next;
	free( tmppop );

	return ret;
}

int actualPos()
{
	return sptr;
}