/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "formTrans.h"

int readFile( char *fileName )
{
FILE *fp;
int i = 0;

	fp = fopen( fileName, "r" );

	if ( fp == 0L )
	{
		printf ( "Can't open file %s: No such file or permission denied.\n", fileName );
		return false;
	}

	while ( inCode[i-1] != EOF )
	{

		inCode[i] = fgetc(fp);
		i++;

		if ( i == IN_LEN )
		{
			printf ( "File %s too long (> %d bytes).\n", fileName, IN_LEN );
			return false;
		}
	}

	inCode[i-1] = 0L;

	fclose(fp);

	return true;

} // ReadFile(...)



void printUsage()
{
	printf( "\nUse: vkFormTranslator -c input.vkf cpp-template h-template input.vkc\n" );
	printf( "\nOr: vkFormTranslator [-c] [-m] input.vktf [cpp-template h-template] input.vkc\n" );

	printf ( "\n\n" );

	printf ( "Options:\n" );
	printf ( "	-c : Create class code.\n" );
	printf ( "	-m : Create master class code, only for *.vktf\n\n" );
	printf ( "You must give at least one of these options!\n" );
}


void setVkf( char *name, int isTop )
{

	if ( !readFile(name) )
		abort();

	if ( vkf[0] != 0 )
	{
		printf ( "More than one *.vk(t)f input file.\n" );
		printUsage();
		exit(1);
	}


	strcat( vkf, inCode );

	if ( isTop )
	{
		/* *.vktf: */
		outF = (char *) malloc( (strlen(name)-4)*sizeof(char) );
		strncpy( outF, name, strlen(name)-5 );
		outF[strlen(name)-5] = 0L;

		makeWindow = 1;
	}
	else
	{
		/* *.vkf: */
		outF = (char *) malloc( (strlen(name)-3)*sizeof(char) );
		strncpy( outF, name, strlen(name)-4 );
		outF[strlen(name)-4] = 0L;

		makeWindow = 0;
	}

}


void setCppt( char *name )
{

	if ( !readFile(name) )
		abort();

	if ( cppT[0] != 0 )
	{
		printf ( "More than one cpp-template file.\n" );
		printUsage();
		exit(1);
	}


	strcat( cppT, inCode );
}


void setHt( char *name )
{

	if ( !readFile(name) )
		abort();

	if ( hT[0] != 0 )
	{
		printf ( "More than one h-template file.\n" );
		printUsage();
		exit(1);
	}


	strcat( hT, inCode );
}


void setVkc( char *name )
{

	if ( !readFile(name) )
		abort();

	if ( vkc[0] != 0 )
	{
		printf ( "More than *.vkc file.\n" );
		printUsage();
		exit(1);
	}


	strcat( vkc, inCode );
}


void checkForMain()
{
int i, ii;

	ii = 0;

	for( i = 0; vkc[i] != 0L; i++ )
	{
		if ( vkc[i] == '#' ) ii++;

		if ( ii == 4 )
			if ( vkc[ii+2] == 'M' ) //"MAIN" must follow
				isMain = 1;
			else
				isMain = 0;


	}
	
}


int setMode( int c, int m )
{
	if ( vkf[0] == 0 )
	{
		printf ( "Missing *.vk(t)f file.\n" );
		printUsage();
		exit(1);
	}

	if ( vkc[0] == 0 )
	{
		printf ( "Missing *.vkc file.\n" );
		printUsage();
		exit(1);
	}


	if(m && !makeWindow)
	{
		printf ( "Master class can only be produced for top level windows.\n" );
		printUsage();
		exit(1);
	}

	if ( makeWindow )
	{
		checkForMain();

		if (isMain && c && m)
		{
			printf( "Warning: Building window class and master class " );
			printf( "together in one file is\n         not recommended for " );
			printf( "main window.\n" );
		}
		else
			printf( "Please rebuild the master class of your main window, after doing this.\n" );

	}
	else
	{
		printf( "Please rebuild this widget's parent, or (if its parent is a " );
		printf( "window) the\nmaster class of its parent.\n" );
	}

	if(c)
	{
		if( cppT[0] == 0 )
		{
			printf ( "Missing cpp-template file with '-c' option given.\n" );
			printUsage();
			exit(1);
		}

		if( hT[0] == 0 )
		{
			printf ( "Missing h-template file with '-c' option given.\n" );
			printUsage();
			exit(1);
		}
	}

	buildBase = c;
	buildMaster = m;

} //setMode()


void parseArgs( int num, char **args )
{
int i;
int c = 0, m = 0;
regex_t vkfFile, vktfFile, cppTemplate, hTemplate, vkcFile;

	regcomp( &vkfFile, "[0-9a-zA-Z_-]+(.vkf)", REG_EXTENDED|REG_NOSUB );
	regcomp( &vktfFile, "[0-9a-zA-Z_-]+(.vktf)", REG_EXTENDED|REG_NOSUB );
	regcomp( &cppTemplate, "(cpp\\-)[0-9a-zA-Z_\\-]+", REG_EXTENDED|REG_NOSUB );
	regcomp( &hTemplate, "(h-)[0-9a-zA-Z_\\-]+", REG_EXTENDED|REG_NOSUB );
	regcomp( &vkcFile, "[0-9a-zA-Z_\\-]+(.vkc)", REG_EXTENDED|REG_NOSUB );

	// 1) Find options ( c, m )

	for( i = 0; i < num; i++ )
		if ( args[i][0] == '-' )
		{
			if ( strlen( args[i] ) == 1 )
			{
				printf ( "No option given after '-'.\n" );
				printUsage();
				exit(1);
			}

			if ( strlen( args[i] ) > 3 )
			{
				printf ( "To many arguments given after '-'\n" );
				printUsage();
				exit(1);
			}

			if ( args[i][1] == 'c' )
				c = 1;
			else if( args[i][1] == 'm' )
				m = 1;
			else
			{
				printf( "Illegal option %c.\n", args[i][1] );
				printUsage();
				exit(1);
			}


			if( strlen( args[i] ) == 3)
			{
				if( args[i][2] == 'c' )
					c = 1;
				else if( args[i][2] == 'm' )
					m = 1;
				else
				{
					printf( "Illegal option %c.\n", args[i][2] );
					printUsage();
					exit(1);
				}
			}


		} //if

	// 2) Is a option given ?
	if ( !c && !m )
	{
		printUsage();
		exit(1);
	}


	// 3) Get files:
	for( i = 1; i < num; i++ )
		if ( args[i][0] != '-' )
		{

			if ( regexec(&vkfFile , args[i], 0, 0, 0 ) == 0 )
				setVkf( args[i], 0 );
			else if ( regexec(&vktfFile , args[i], 0, 0, 0 ) == 0 )
				setVkf( args[i], 1 );
			else if ( regexec(&cppTemplate , args[i], 0, 0, 0 ) == 0 )
				setCppt( args[i] );
			else if ( regexec(&hTemplate , args[i], 0, 0, 0 ) == 0 )
				setHt( args[i] );
			else if ( regexec(&vkcFile , args[i], 0, 0, 0 ) == 0 )
				setVkc( args[i] );
			else
			{
				printf ( "Can't recognize file %s.\n", args[i] );
				printUsage();
				exit(1);
			}

		}

	setMode(c,m);


} //parseArgs(...)


void clearSubO()
{
int i, ii;

	for( i = 0; i < EXPR_LEN; i++ )
	{
		vkfSubO.name[i] = 0L;
		vkfSubO.type[i] = 0L;

		for( ii = 0; ii < MAX_ENTRS; ii++ )
		{
			vkfSubO.sprops[ii][0][i] = 0L;
			vkfSubO.sprops[ii][1][i] = 0L;
		}
	}

}


void addSubProp( char *n, char *v )
{
int i;
	for( i = 0; vkfSubO.sprops[i][0][0] != 0L; i++ )
		if ( i == MAX_ENTRS-1 )
		{
			printf( "Too many properties in sub widget.\n" );
			exit(2);
		}

	strcat( vkfSubO.sprops[i][0], n );
	strcat( vkfSubO.sprops[i][1], v );
}


int parseSubProp( int i )
{
int ii;
char expr1[EXPR_LEN], expr2[EXPR_LEN];

	while( vkf[i] != ')' )
	{
		ii = 0;

		while( vkf[i] != '=' )
		{
			if( !isalnum(vkf[i]) )
			{
				printf ( "Incorrect *.vk(t)f file: Wrong sub widget property.\n" );
				exit(2);
			}

			expr1[ii] = vkf[i];

			i++; ii++;

			if ( ii == EXPR_LEN )
			{
				printf( "Name of property of sub widget too long.\n" );
				exit(2);
			}
		}

		expr1[ii] = 0L;

		i++;

		if( vkf[i] != '"' )
		{
			printf ( "Incorrect *.vk(t)f file: '\"' expected #1.\n" );
			exit(2);
		}


		i++; ii = 0;

		while( vkf[i] != '"' )
		{

			if ( vkf[i] == 0L )
			{
				printf ( "Incorrect *.vk(t)f file: Unterminated string.\n" );
				exit(2);
			}

			expr2[ii] = vkf[i];

			i++; ii++;

			if ( ii == EXPR_LEN )
			{
				printf( "Value of property \"%s\" of sub widget \"%s\" too long.\n",
					expr2, vkfSubO.name );
				exit(2);
			}
		}

		expr2[ii] = 0L;

		addSubProp( expr1, expr2 );

		i++;


		if( vkf[i] != ';' )
		{
			printf ( "Incorrect *.vk(t)f file: ';' expected.\n" );
			exit(2);
		}

		i++;

	} //while

	return i;

}


void addByte( char *str, char nc )
{
int i;
	for( i = 0; str[i] != 0; i++ )
		if( i >= EXPR_LEN-1 )
		{
			printf ( "Expression too long ( > %d bytes ).\n", EXPR_LEN );
			exit(2);
		}

	str[i] = nc;
	str[i+1] = 0L;


}


int toInt( char *str )
{
int i, vm = 1;
int ret = 0;

	for( i = strlen(str)-1; i >= 0; i-- )
	{
		if ( !isdigit(str[i]) )
		{
			printf( "String contains trash (Can't convert to int).\n" );
			exit(2);
		}

		ret += (str[i]-48) *vm;

		vm = vm *10;
	}

	return ret;

}


/* Scanner/parser: */
void checkVkf()
{
int i, ii = 0;
int strMode = 0;
char expr1[EXPR_LEN] = "", expr2[EXPR_LEN];


	for( i = 0; vkf[i] != 0L; i++ )
	{
		if( vkf[i] == '"' )
			strMode = !strMode;

		if( !strMode && isalpha(vkf[i]) )
		{
			vkf[i] = tolower( vkf[i] );
		}

		if ( strMode || ( vkf[i] != ' ' && vkf[i] != '\n' && vkf[i] != '\t' ) )
		{
			vkf[ii] = vkf[i];
			ii++;
		}

	}


	printf ( "Please wait...\n" );
	initInF( &vkfStruct );

	vkf[i] = 0L;


	if ( makeWindow && strncmp(vkf, "window", 6) != 0 )
	{
		printf ( "Incorrect *.vk(t)f file: \"Window\" expected.\n" );
		exit(2);
	}
	else if ( !makeWindow && strncmp(vkf, "subwindow", 9) != 0 )
	{
		printf ( "Incorrect *.vk(t)f file: \"SubWindow\" expected.\n" );
		exit(2);
	}

	if( strncmp(vkf, "window", 6) == 0 )
		i = 6;
	else
		i = 9;

	for( ; vkf[i] != '('; i++ )
	{
		if( !isalnum(vkf[i]) )
		{
			printf ( "Incorrect *.vk(t)f file: Incorrect name.\n" );
			exit(2);
		}


		addByte( expr1, vkf[i] );
	}

	setInFName( &vkfStruct, outF );

	i++;

	if ( strncmp(vkf+(i*sizeof(char)), "properties(", 11) != 0 )
	{
		printf ( "Incorrect *.vk(t)f file: \"Properties\" expected.\n" );
		exit(2);
	}

	i += 11;

	while( vkf[i] != ')' )
	{

		expr1[0] = 0L;
		expr2[0] = 0L;

		while( vkf[i] != '=' )
		{
			if( !isalnum(vkf[i]) )
			{
				printf ( "Incorrect *.vk(t)f file: Wrong property.\n" );
				exit(2);
			}

			addByte( expr1, vkf[i] );

			i++;
		}

		i++;

		if( vkf[i] != '"' )
		{
			printf ( "Incorrect *.vk(t)f file: '\"' expected #2.\n" );
			exit(2);
		}


		i++;

		while( vkf[i] != '"' )
		{

			if ( vkf[i] == 0L )
			{
				printf ( "Incorrect *.vk(t)f file: Unterminated string.\n" );
				exit(2);
			}

			addByte(expr2, vkf[i] );

			i++;
		}

		i++;


		if( vkf[i] != ';' )
		{
			printf ( "Incorrect *.vk(t)f file: ';' expected.\n" );
			exit(2);
		}

		i++;

		setInFProp( &vkfStruct, expr1, expr2 );

	} //while


	i++;


	if ( strncmp(vkf+(i*sizeof(char)), "regional(", 9) != 0 )
	{
		printf ( "Incorrect *.vk(t)f file: \"Regional\" expected.\n" );
		exit(2);
	}

	i += 9;


	while( vkf[i] != ')' )
	{

		expr1[0] = 0L;
		expr2[0] = 0L;

		while( vkf[i] != '=' )
		{
			if( !isalnum(vkf[i]) && vkf[i] != '_' )
			{
				printf ( "Incorrect *.vk(t)f file: Wrong variable name.\n" );
				exit(2);
			}

			addByte( expr1, vkf[i] );

			i++;
		}

		i++;

		if( vkf[i] != '"' )
		{
			printf ( "Incorrect *.vk(t)f file: '\"' expected #3.\n" );
			exit(2);
		}


		i++;

		while( vkf[i] != '"' )
		{

			if ( vkf[i] == 0L )
			{
				printf ( "Incorrect *.vk(t)f file: Unterminated string.\n" );
				exit(2);
			}

			addByte( expr2, vkf[i] );

			i++;
		}

		i++;


		if( vkf[i] != ';' )
		{
			printf ( "Incorrect *.vk(t)f file: ';' expected.\n" );
			exit(2);
		}

		i++;

		setInFVar( &vkfStruct, expr1, expr2 );

	} //while

	i++;



	if ( strncmp(vkf+(i*sizeof(char)), "regconst(", 9) != 0 )
	{
		printf ( "Incorrect *.vk(t)f file: \"RegConst\" expected.\n" );
		exit(2);
	}

	i += 9;


	while( vkf[i] != ')' )
	{
		expr1[0] = 0L;
		expr2[0] = 0L;

		while( vkf[i] != '=' )
		{
			if( !isalnum(vkf[i]) && vkf[i] != '_' )
			{
				printf ( "Incorrect *.vk(t)f file: Wrong const name.\n" );
				exit(2);
			}

			addByte( expr1, vkf[i] );

			i++;
		}

		i++;

		if( vkf[i] != '"' )
		{
			printf ( "Incorrect *.vk(t)f file: '\"' expected #4.\n" );
			exit(2);
		}


		i++;

		while( vkf[i] != '"' )
		{

			if ( vkf[i] == 0L )
			{
				printf ( "Incorrect *.vk(t)f file: Unterminated string.\n" );
				exit(2);
			}

			addByte( expr2, vkf[i] );

			i++;
		}

		i++;


		if( vkf[i] != ';' )
		{
			printf ( "Incorrect *.vk(t)f file: ';' expected.\n" );
			exit(2);
		}

		i++;

		setInFConst( &vkfStruct, expr1, expr2 );

	} //while

	i++;


	if ( strncmp(vkf+(i*sizeof(char)), "functions(", 10) != 0 )
	{
		printf ( "Incorrect *.vk(t)f file: \"Functions\" expected.\n" );
		exit(2);
	}

	i += 10;


	while( vkf[i] != ')' )
	{
		expr1[0] = 0L;
		expr2[0] = 0L;

		while( vkf[i] != ':' )
		{
			if( !isalnum(vkf[i]) && vkf[i] != '_' )
			{
				printf ( "Incorrect *.vk(t)f file: Wrong function name.\n" );
				exit(2);
			}

			addByte( expr1, vkf[i] );

			i++;
		}

		i++;

		if ( !isdigit( vkf[i] ) )
		{
			printf ( "Incorrect *.vk(t)f file: Wrong function argument number.\n" );
			exit(2);
		}

		while( isdigit( vkf[i] ) )
		{
			addByte( expr2, vkf[i] );
			i++;
		}

		if( vkf[i] != ';' )
		{
			printf ( "Incorrect *.vk(t)f file: ';' expected.\n" );
			exit(2);
		}

		i++;

		setInFFunc( &vkfStruct, expr1, toInt(expr2) );

	} //while

	i++;


	//Sub widgets:

	if ( strncmp(vkf+(i*sizeof(char)), "subwidgets(", 11) != 0 )
	{
		printf ( "Incorrect *.vk(t)f file: \"SubWidgets\" expected.\n" );
		exit(2);
	}

	i += 11;


	while( vkf[i] != ')' )
	{
		clearSubO();

		if ( strncmp(vkf+(i*sizeof(char)), "subwindow", 9) == 0 )
		{
			strcat( vkfSubO.type, "SubWindow" );
			i += 9;
		}
		else if ( strncmp(vkf+(i*sizeof(char)), "button", 6) == 0 )
		{
			strcat( vkfSubO.type, "Button" );
			i += 6;
		}
		else if ( strncmp(vkf+(i*sizeof(char)), "label", 5) == 0 )
		{
			strcat( vkfSubO.type, "Label" );
			i += 5;
		}
		else if ( strncmp(vkf+(i*sizeof(char)), "pixlabel", 8) == 0 )
		{
			strcat( vkfSubO.type, "PixLabel" );
			i += 8;
		}
		else if ( strncmp(vkf+(i*sizeof(char)), "lineedit", 8) == 0 )
		{
			strcat( vkfSubO.type, "LineEdit" );
			i += 8;
		}
		else if ( strncmp(vkf+(i*sizeof(char)), "listbox", 7) == 0 )
		{
			strcat( vkfSubO.type, "ListBox" );
			i += 7;
		}
		else if ( strncmp(vkf+(i*sizeof(char)), "checkbox", 8) == 0 )
		{
			strcat( vkfSubO.type, "CheckBox" );
			i += 8;
		}
		else if ( strncmp(vkf+(i*sizeof(char)), "optionbutton", 12) == 0 )
		{
			strcat( vkfSubO.type, "OptionButton" );
			i += 12;
		}
		else if ( strncmp(vkf+(i*sizeof(char)), "slider", 6) == 0 )
		{
			strcat( vkfSubO.type, "Slider" );
			i += 6;
		}
		else if ( strncmp(vkf+(i*sizeof(char)), "procctrl", 8) == 0 )
		{
			strcat( vkfSubO.type, "ProcCtrl" );
			i += 8;
		}
		else
		{
			printf ( "Incorrect *.vk(t)f file: Widget type expected.\n" );
			exit(2);
		}

		ii = 0;

		while( vkf[i] != '(' )
		{
			if( !isalnum(vkf[i]) )
			{
				printf ( "Incorrect *.vk(t)f file: Wrong sub object name.\n" );
				exit(2);
			}

			vkfSubO.name[ii] = vkf[i];
			ii++;
			i++;

			if( ii == EXPR_LEN )
			{
				printf( "Name of sub widget is too long.\n" );
				exit(2);
			}

		}

		vkfSubO.name[ii] = 0L;

		i++;

		i = parseSubProp(i);

		setInFSub( &vkfStruct, &vkfSubO );

		i++;

	} //while
	


} //checkVkf()



/****************************************************************************
				main program
*****************************************************************************/

main( int argc, char **argv )
{
int append;

	parseArgs( argc, argv );

	if(buildBase) checkVkf();

	if (buildMaster)
	{
		if (!makeMaster())
		{
			printf ( "Failed.\n" );
			exit(3);
		}

		append = 1;
	}
	else
		append = 0;

	if (buildBase)
		if (!makeBase( &vkfStruct, hT, cppT, makeWindow +isMain ))
		{
			printf ( "Failed.\n" );
			exit(3);
		}


	printf( "Finished OK.\n" );

	exit(0);

}

