/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef INFMAN_H
#define INFMAN_H

#include <stdio.h>
#include <string.h>

#include "Dec.h"

/* A structure to keep information about a sub widget declared in
  a *.vk(t)f file:*/
struct subObjs
{
	char name[EXPR_LEN];
	char type[EXPR_LEN];
	char sprops[MAX_ENTRS][2][EXPR_LEN];

};



/* A structure to keep information from in a *.vk(t)f file: */
struct inFile
{
	char name[EXPR_LEN];
	char props[MAX_ENTRS][2][EXPR_LEN];
	char vars[MAX_ENTRS][2][EXPR_LEN];
	char consts[MAX_ENTRS][2][EXPR_LEN];
	char funcs[MAX_ENTRS][EXPR_LEN];
	int funcarg[MAX_ENTRS];
	struct subObjs sobjs[MAX_ENTRS];
};


/* Initializes the given inFile structure: */
void initInF( struct inFile * );

/* Sets the name of the window/widget: */
void setInFName( struct inFile *, char * );

/* Sets the property given through the two strings in the next free place
   in the given inFile: */
void setInFProp( struct inFile *, char *, char * );

/* Sets the varibale given through the two strings in the next free place
   in the given inFile: */
void setInFVar( struct inFile *, char *, char * );

/* Sets the const given through the two strings in the next free place
   in the given inFile: */
void setInFConst( struct inFile *, char *, char * );

/* Sets the function given through the string and the int (argument number)
   in the next free place in the given inFile: */
void setInFFunc( struct inFile *, char *, int );

/* Sets the sub widgets given through the subObjs pointer in the next free place
   in the given inFile: */
void setInFSub( struct inFile *, struct subObjs * );


/* Writes the name from the structure in the given string: */
void getInFName( struct inFile *, char * );

/* Writes the name of the property with number int of inFile in the string: */
void getInPropN( struct inFile *, int, char * );

/* Writes the value of the property with number int of inFile in the string: */
void getInPropV( struct inFile *, int, char * );

/* Writes the name of the variable with number int of inFile in the string: */
void getInVarN( struct inFile *, int, char * );

/* Writes the value of the variable with number int of inFile in the string: */
void getInVarV( struct inFile *, int, char * );

/* Writes the name of the const with number int of inFile in the string: */
void getInConstN( struct inFile *, int, char * );

/* Writes the value of the const with number int of inFile in the string: */
void getInConstV( struct inFile *, int, char * );

/* Writes the name of the function with number int of inFile in the string: */
void getInFuncN( struct inFile *, int, char * );

/* Returns the number of arguments of function number int in inFile or
   -1 if there is no function with this index: */
int getInFuncA( struct inFile *, int );

/* Writes the name of the sub widget with number int of inFile in the string: */
void getInSubN( struct inFile *, int, char * );

/* Writes the type of the sub widget with number int of inFile in the string: */
void getInSubT( struct inFile *, int, char * );

/* Writes the name of property number indx of sub widget with number ix
   of inFile in the string: */
void getInSubPropN( struct inFile *, int ix, int indx, char * );

/* Writes the value of property number indx of sub widget with number ix
   of inFile in the string: */
void getInSubPropV( struct inFile *, int ix, int indx, char * );

//void debug( struct inFile * );

#endif
