/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef TOPWIN_H
#define TOPWIN_H

#include <qwidget.h>
#include <qstring.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qpalette.h>
#include <ctype.h>
#include <qlineedit.h>

#include "wholder.h"
#include "ewidgets.h"

/******************************************************************************
	A widget that looks like a title bar for topWin:
*******************************************************************************/
class titleBar : public QWidget
{
	Q_OBJECT

public:
	titleBar( QWidget *, QWidget *cW );

	void setText( QString );

signals:
	void textChanged( QString );

private:
	void drawWidget();

	virtual void paintEvent( QPaintEvent * );

	virtual void mousePressEvent( QMouseEvent * );
	virtual void mouseReleaseEvent( QMouseEvent * );
	virtual void mouseMoveEvent( QMouseEvent * );

	virtual void resizeEvent( QResizeEvent * );
	virtual void mouseDoubleClickEvent( QMouseEvent * );

	bool moveMode;
	int mX, mY;

	QString title;

	QWidget *cW;

	eQLineEdit *newTitle;

private slots:
	void cancelChange();
	void acceptChange();

};



/*********************************************************************************
	A widget looking like a window:
*********************************************************************************/

class topWin : public widgetHolder
{
	Q_OBJECT

public:
	topWin( QWidget * );

	int tHeight() { return tBar->height(); }

	void move( int, int ); //Differs a little from Qt's move

	void destroyBars();
	

protected:
	virtual void newProperties( QString props[], QString vals[] );

private:
	void drawPix();

	void positionTitle();
	void changeTitle( QString );

	int r, g, b;

	QPixmap pix;

	titleBar *tBar;

private slots:
	void tbTitle( QString );

};

#endif
