/***************************************************************************
                          tagimgdlg.cpp  -  description
                             -------------------
    begin                : Sat Nov 27 1999
    copyright            : (C) 1999 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "tagimgdlg.h"
#include <qspinbox.h>

#include <kfiledialog.h>
#include "quantaview.h"
#include "quantadoc.h"

#include "pictureview.h"
#include "qextfileinfo.h"

#include <kfiledialog.h>
#include <kmsgbox.h>

static const char *align[] = { "", "left", "right", "top", "bottom", "middle",0};

TagImgDlg::TagImgDlg(QWidget *parent, const char *name) : QDialog(parent,name,true){
	setCaption(name);
	initDialog();
	
	comboAlign->insertStrList(align);
	
	connect( buttonOk, SIGNAL(clicked()), SLOT(accept()) );
	connect( buttonCancel, SIGNAL(clicked()), SLOT(reject()) );
	connect( buttonImgSource, SIGNAL(clicked()), this, SLOT(slotFileSelect()) );
	connect( lineImgSource, SIGNAL( returnPressed()), this, SLOT(slotLineFileSelect()) );
}

TagImgDlg::~TagImgDlg(){
}

/** Choose new image */
void TagImgDlg::slotImageSet( char * file){
	widgetImg->slotSetImage(file);
	
	QImage img(file);
	QString filename = file;
	if (img.isNull()) {
		filename = "Can't load image \""+filename+"\" !!!";
		KMsgBox::message(this,"Error...",filename,KMsgBox::EXCLAMATION);
		return;
	}
	
	QString s;
	s.setNum( img.width() );
	lineWidth->setText( s.data() );
	s.setNum( img.height() );
	lineHeight->setText( s.data() );
	
}

/** select image */
void TagImgDlg::slotFileSelect(){
		QString basePath = ((QuantaView *)parent())->getDocument()->basePath;
		
		QString fileName = KFileDialog::getOpenFileName(basePath, "*.gif *.jpg *.png *.GIF *.JPG *.PNG| Image files\n*|All files");
		if (fileName.isEmpty()) return;
		
		QExtFileInfo file(fileName);
		file.convertToRelative(basePath);
		QString shortName = file.filePath();
		lineImgSource->setText(shortName);
		
		slotImageSet( fileName.data() );
}


void TagImgDlg::slotLineFileSelect(){
		slotImageSet( (char *)lineImgSource->text() );
}
