/*
 *
 * $Id$
 */

#include "kwritecdr.h"
#include "kwritecdr.moc"

#include <qmsgbox.h>
#include <sys/types.h>
#include <sys/stat.h>

KWriteCdr::KWriteCdr( QWidget *parent = 0, KTrackListBox *aBufListBox = 0 )
  : QGroupBox( parent, "KWriteCdr" )
{
  bufListBox = aBufListBox;

  config = kapp->getConfig();
  proc = new KShellProcess();

  QSize size;          // we'll need it anyway....

  QBoxLayout *layout0 = new QHBoxLayout( this, 8, 3 );  // is TopLevelLayout
  
  /////////////////////////////////////////////////////////////////
  // left side....

  QBoxLayout *layout1 = new QVBoxLayout( this );
  layout0->addLayout( layout1 );
  
  writeListBox = new KTrackListBox( this, "writeListBox", 4);
  writeListBox->setColumn( 0, klocale->translate("Title"), 120);
  writeListBox->setColumn( 1, klocale->translate("Time"), 50);
  writeListBox->setColumn( 2, klocale->translate("Size"), 35);
  writeListBox->setColumn( 3, klocale->translate("Filename"), 200);
  writeListBox->setSeparator('\t');
  writeListBox->allowDrag( true );
  writeListBox->setDragSource( 2 );
  layout1->addWidget( writeListBox );
  dropZone = new KDNDDropZone( writeListBox, DndRawData );
  connect( dropZone, SIGNAL( dropAction( KDNDDropZone * ) ), this, SLOT( dropAction( KDNDDropZone * ) ) );

  ////////////////////////////////////////////////////////////////////////////
  //  right side.....

  int rightWidth;               // stores the width of the biggest element....

  QWidget *right = new QWidget( this, "right" );
  right->setFixedWidth( 130 );
  layout0->addWidget( right );
  
  layout1 = new QVBoxLayout( right );
  
  // control buttons
  QPushButton *pbt = new QPushButton( "->", right );
  pbt->setGeometry( 5, 20, 40, 30 );
  connect( pbt, SIGNAL( clicked() ), this, SLOT( pbtAddTracks() ) ); 
  pbt = new QPushButton( "->>", right );
  pbt->setGeometry( 45, 20, 40, 30 );
  connect( pbt, SIGNAL( clicked() ), this, SLOT( pbtAddAllTracks() ) );
  pbt = new QPushButton( "X", right );
  pbt->setGeometry( 85, 20, 40, 30 );
  connect( pbt, SIGNAL( clicked() ), this, SLOT( pbtDelTracks() ) ); 
  pbt = new QPushButton( "up", right );
  pbt->setGeometry( 5, 50, 60, 30 );
  connect( pbt, SIGNAL( clicked() ), this, SLOT( pbtUpTrack() ) ); 
  pbt = new QPushButton( "down", right );
  pbt->setGeometry( 65, 50, 60, 30 );
  connect( pbt, SIGNAL( clicked() ), this, SLOT( pbtDownTrack() ) ); 

  layout1->addSpacing( 90 );  

  // the CDR-Length Radio-Button Box
  QButtonGroup *cdrLength = new QButtonGroup( klocale->translate("CDR-Length"), right );
  QBoxLayout *layout2 = new QVBoxLayout( cdrLength, 5, 0 );
  layout2->addSpacing( 10 );
  CdrLength74 = new QRadioButton( klocale->translate("74min (650MB)"), cdrLength);
  layout2->addWidget( CdrLength74 );
  CdrLength63= new QRadioButton( klocale->translate("63min (553MB)"), cdrLength);
  layout2->addWidget( CdrLength63 );
  size = CdrLength63->sizeHint();
  rightWidth = size.width()+20;
  cdrLength->setFixedHeight( size.height()*4 );
  layout1->addWidget( cdrLength );

  // some check boxes....
  QGroupBox *group = new QGroupBox("Settings", right);
  layout2 = new QVBoxLayout( group, 5, 0 );
  layout2->addSpacing( 10 );
  dummyWrite = new QCheckBox( klocale->translate("Simulation Write"), group);
  layout2->addWidget( dummyWrite );
  ejectAfterWrite = new QCheckBox( klocale->translate("Eject after Write"), group);
  layout2->addWidget( ejectAfterWrite );
  size = dummyWrite->sizeHint();
  group->setFixedHeight( size.height()*4 );
  layout1->addWidget( group );
  
  // CDR-Usage stuff.......
  group = new QGroupBox( klocale->translate("CDR-Usage"), right );
  layout2 = new QVBoxLayout( group, 5, 0 );
  layout2->addSpacing( 10 );
  cdrSize = new QLabel("Size: 0", group);
  layout2->addWidget( cdrSize );
  cdrTime = new QLabel("Time: 00:00", group);
  layout2->addWidget( cdrTime );
  cdrUsage = new KProgress( 0, 100, 0, KProgress::Horizontal, group );
  size = cdrUsage->sizeHint();
  cdrUsage->setFixedHeight( size.height() );
  group->setFixedHeight( size.height()*4 );
  layout2->addWidget( cdrUsage );  
  layout1->addWidget( group );
  
  // and finally th "GO !" Button....
  startWriting = new QPushButton( klocale->translate("&Start Writing"), right );
  size = startWriting->sizeHint();
  startWriting->setFixedSize( size );
  layout1->addSpacing( 10 );
  layout1->addWidget( startWriting );  
  connect( startWriting, SIGNAL( clicked() ), this, SLOT( pbtStartWriting() ) );

  // adjust widgets
  config->setGroup( "general" );
  if ( config->readEntry("CdrLength", "74") == "63" ) {
    CdrLength63->setChecked( TRUE );
    CdrLength74->setChecked( FALSE );
  } else {
    CdrLength63->setChecked( FALSE );
    CdrLength74->setChecked( TRUE );    
  }
  if ( config->readEntry("DummyWrite", "1") == "0" ) {
    dummyWrite->setChecked( FALSE );
  } else {
    dummyWrite->setChecked( TRUE );
  };
  if ( config->readEntry("EjectAfterWrite", "1") == "0" ) {
    ejectAfterWrite->setChecked( FALSE );
  } else {
    ejectAfterWrite->setChecked( TRUE );
  };
}

KWriteCdr::~KWriteCdr()
{
}

void KWriteCdr::dropAction( KDNDDropZone *zone )
{
  QPoint point;
  DragData *dd;
  int row;                            // where has it been droped ?
  int i;

  dd = (DragData *)zone->getData();  // droped data
  point.setX( 0 );
  point.setY( zone->getMouseY() );
  point = writeListBox->mapFromGlobal( point );
  row = writeListBox->findRow( point.y() );

  switch ( dd->dragSource )
    {
    case 0:                                                             // drop from buffer
      int listCount;
      CdTrackInfo *track;

      writeListBox->setAutoUpdate( false );
      listCount = dd->listBox->count();
      for ( i=0; i<listCount; i++ ) {
	if ( dd->listBox->isMarked( i ) ) {
	  track = new CdTrackInfo( dd->listBox->track( i ) );
	  writeListBox->insertTrack( track, dd->listBox->title( i ), dd->listBox->filename( i ), row );
	  row++;
	}
      };
      writeListBox->unmarkAll();
      writeListBox->setAutoUpdate( true );
      writeListBox->repaint();
      dd->listBox->unmarkAll();
      updateUsage();
      break;
    case 2:                                                            // drop from myself - reorder
      writeListBox->setAutoUpdate( false );
      i = writeListBox->currentItem();
      writeListBox->insertTrack( writeListBox->track( i ), writeListBox->title( i ), writeListBox->filename( i ), row );
      if ( row < i ) i++;
      writeListBox->removeTrack( i );
      writeListBox->unmarkAll();
      writeListBox->setCurrentItem( row );
      writeListBox->setAutoUpdate( true );
      writeListBox->repaint();
      break;
    default:
      KDEBUG( KDEBUG_ERROR, 0, "could not handle droped data !" );
      break;
    };
}

void KWriteCdr::updateUsage()
{
  int i, listCount;
  int size, time;
  QString tmp;
  CdTrackInfo *track;
  
  size = time = 0;
  listCount = writeListBox->count();
  for ( i=0; i<listCount; i++ ) {
    track = writeListBox->track( i );
    size += track->trackSize();
    time += track->trackTime();
  };
  
  if ( time <= 74*60 ) {
    tmp = klocale->translate( "Time: " ) + tmp.sprintf( "%02d:%02d", time / 60, time % 60 );
    cdrTime->setText( tmp );
    tmp = klocale->translate( "Size: " ) + tmp.sprintf( "%d MB", size / 1024 );
    cdrSize->setText( tmp );
    i = time*100  / ( 74 * 60);
    cdrUsage->setBarColor( QColor( 0x00, 0x00, 0xAA ) );
  } else {
    tmp = klocale->translate( "Time: " ) + tmp.sprintf( "74:00 + %02d:%02d", (time / 60)-74, time % 60 );
    cdrTime->setText( tmp );
    tmp = klocale->translate( "Size: " ) + tmp.sprintf( "650 + %d MB", (size / 1024) - 650 );
    cdrSize->setText( tmp );
    i = time*100  / ( 74 * 60);
    cdrUsage->setBarColor( QColor( 0xCC, 0x00, 0x00 ) );
    emit updateStatus( "tracks dont fit onto one cdr !", -1 );
  }
  cdrUsage->setValue( i );
}

void KWriteCdr::setFilename( CdTrackInfo *track, QString filename )
{
  int i;
  
  i = writeListBox->pos( track );
  if ( i != -1 ) {
    writeListBox->setFilename( i, filename );
  };
}

void KWriteCdr::setTitle( CdTrackInfo *track, QString title )
{
}

void KWriteCdr::pbtAddTracks()
{
  int listCount, i;
  CdTrackInfo *track;
  
  writeListBox->setAutoUpdate( false );
  listCount = bufListBox->count();
  for( i=0; i<listCount; i++ ) {
    if ( bufListBox->isMarked( i ) ) {
      track = new CdTrackInfo( bufListBox->track( i ) );
      writeListBox->insertTrack( track, bufListBox->title( i ), bufListBox->filename( i ) );
    }
  };
  writeListBox->setCurrentItem( writeListBox->count()-1 );
  writeListBox->setAutoUpdate( true );
  writeListBox->repaint();
  updateUsage();
}

void KWriteCdr::pbtAddAllTracks()
{
  int i, listCount;
  
  bufListBox->setAutoUpdate( false );
  listCount = bufListBox->count();
  for ( i=0; i < listCount; i++ ) {
    bufListBox->markItem( i );
  };
  pbtAddTracks();
  bufListBox->unmarkAll();
  bufListBox->setAutoUpdate( true );
}

void KWriteCdr::pbtDelTracks()
{
  int i, listCount, first;

  writeListBox->setAutoUpdate( false );
  listCount = writeListBox->count();
  first = -1;
  for( i=0; i<listCount; i++ ) {
    if ( writeListBox->isMarked( i ) ) {
      if ( first == -1 ) first = i;
      writeListBox->unmarkItem( i );        // needed - bug in KTabListBox
      delete writeListBox->track( i );
      writeListBox->removeTrack( i );
      listCount--; i--;
    };
  };
  writeListBox->unmarkAll();
  writeListBox->setCurrentItem( first );
  writeListBox->setAutoUpdate( true );
  writeListBox->repaint();
  updateUsage();
}

void KWriteCdr::pbtUpTrack()
{
  int cur= writeListBox->currentItem();
  
  if ( cur > 0 ) {
    writeListBox->setAutoUpdate( false );
    writeListBox->insertTrack( writeListBox->track( cur ), writeListBox->title( cur ), writeListBox->filename( cur ), cur-1 );
    writeListBox->removeTrack( cur+1 );
    writeListBox->setCurrentItem( cur-1 );
    writeListBox->setAutoUpdate( true );
    writeListBox->repaint();
  };
}

void KWriteCdr::pbtDownTrack()
{
  int cur= writeListBox->currentItem();
  
  if ( cur < writeListBox->count()-1 ) {
    writeListBox->setAutoUpdate( false );
    writeListBox->insertTrack( writeListBox->track( cur ), writeListBox->title( cur ), writeListBox->filename( cur ), cur+2 );
    writeListBox->removeTrack( cur );
    writeListBox->setCurrentItem( cur+1 );
    writeListBox->setAutoUpdate( true );
    writeListBox->repaint();
  };
}

void KWriteCdr::pbtStartWriting()
{
  if ( proc->isRunning() ) {
    QMessageBox::warning( this, "kcdwrite", klocale->translate( "start writing ? - sorry cant - i *AM* already writing." ) ) ;
  } else {
    int i, listCount;
    bool Ok;
    QString execute, tmp, tmp2, filename;
    mode_t mode;

    // first chack if all queued tracks are completly read.
    listCount = writeListBox->count();
    Ok = true;
    for ( i=0; i < listCount; i++ ) {
      if ( writeListBox->filename( i ).left( 1 ) != "/" ) Ok = false;
    }
    if ( ! Ok ) {
      QMessageBox::warning( this, "kcdwrite", klocale->translate( "You have to wait until audio-track reading finished..." ) );
    } else {
      filename = config->readEntry( "BufferPath", "/tmp/" )+"job";
      execute = "";
      switch ( config->readNumEntry( "WritingTool", 0 ) )
	{
	case 0:                                     // cdrecord
	  execute = config->readEntry( "WritingToolPath", "cdrecord" )+" ";
	  if ( dummyWrite->isChecked() ) execute += "-dummy ";
	  if ( ejectAfterWrite->isChecked() ) execute += "-eject ";
	  execute += config->readEntry( "WritingTool0Options", "" )+" -audio ";
	  for ( i=0; i<listCount; i++ ) {
	    execute += writeListBox->filename( i );
	    execute += " ";
	  };
	  break;
	default:
	  QMessageBox::warning( this, "kcdwrite", klocale->translate( "Sorry, dont know which tool to use.\n Please choose " \
								      "<File>/<Configure...>\n" ) );
	  break;
	};
      if ( ! execute.isEmpty() ) {
	tmp2 = config->readEntry( "BufferPath", "/tmp/" )+"kcdwrite.log";
	tmp.sprintf( " > %s 2>&1\n\n", tmp2.data() );
	execute += tmp;

	QFile f( filename );
	if ( f.open( IO_WriteOnly ) ) {
	  QTextStream stream( &f );
	  stream << "#!/bin/sh\n\n";
	  stream << execute;
	  f.close();

	  mode = S_IRUSR || S_IWUSR || S_IXUSR;
	  chmod( filename.data(), mode );
	  
	  tmp.sprintf( klocale->translate( "Job written to \"%s\".\nPlease insert a CDR and hit \"Run\"\n" ),
		       filename.data() );
	  if ( QMessageBox::information( this, "kcdwrite", tmp,
					 klocale->translate( "Run NOW !" ), klocale->translate( "Don`t run" ), 0, 
					 0, 1 ) == 0 ) {

	    delete proc;
	    proc = new KShellProcess();
	    connect( proc, SIGNAL( processExited( KProcess * ) ), this, SLOT( childExited( KProcess * ) ) );
	    *proc << filename;
	    emit updateStatus( klocale->translate( "  ->> writing CDR <<-  " ), -1 );
	    proc->start();
	  } else {
	    tmp.sprintf( klocale->translate( "Job written to \"%s\" " ), filename.data() );
	    emit updateStatus( tmp, -1 );
	  }
	} else {
	  tmp.sprintf( klocale->translate( "Error:\n\n  Could not open file \"%s\" for writing..." ), filename.data() );
	  QMessageBox::critical( this, "kcdwrite", tmp );
	}
      }
    }
  }
}

void KWriteCdr::childExited( KProcess *proc )
{
  QString tmp;

  if ( proc->normalExit() ) {
    if ( proc->exitStatus() == 0 ) {
      emit updateStatus( klocale->translate( "cdr writing finished !" ), -1 );
      QMessageBox::information( this, "kcdwrite", 
				klocale->translate( "CDR-writing process finished without error - writing completed !" ) );
      
    } else {
      tmp.sprintf( klocale->translate( "!Error: CDR-writing process exited with error code %d\n\n" \
				       "        Failure log in \"%skcdwrite.log\"\n" ), 
		   proc->exitStatus(), config->readEntry( "BufferPath", "/tmp/" ).data() );
      QMessageBox::critical( this, "kcdwrite", tmp );
    }
  } else {
    QMessageBox::critical( this, "kcdwrite", klocale->translate( "CDR-writing process got a signal - KILLED !" ) );
  }
}


bool KWriteCdr::quitOk()
{
  if ( proc->isRunning() && ( QMessageBox::warning( this, "kcdwrote", 
						    klocale->translate( "A child-process is currently writing a CDR.\n\n" \
									"   Really quit ?" ),
						    klocale->translate( "&Yes"), klocale->translate( "&No" ), 0, 1, 1) == 1 ) )
    { // dont quit !
      return false;
    } else {
      return true;
    };
}

void KWriteCdr::buffDeleteTrack( CdTrackInfo *track )
{
  int i;
  
  while ( ( i = writeListBox->pos( track ) ) != -1 ) {
    delete writeListBox->track( i );
    writeListBox->removeTrack( i );
  };
}

