#ifndef _KCDWRITE_CDROM_H
#define _KCDWRITE_CDROM_H

/***********************************************************************************
 * 
 *  (c) 1998 Joerg Bornschein <core@disorder.ruhr.de>
 *
 *  $Id: ocdrom.h,v 1.3 1998/08/05 16:36:05 core Exp $
 *
 *
 * I think there is much work to do in here....
 * - I really dont know which header-files are needed on different
 *   systems. It seems even Linux 2.0.x and 2.1.x differ more than
 *   expected :(
 *
 */

// Was needed on my old SuSE System - dunno why :(
// #include <linux/types.h>

#include "config.h"   // autoconf stuff

#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <strings.h>
#include <stdio.h>
#include <linux/cdrom.h>

#ifdef HAVE_LINUX_UCDROM_H
// needed on Linux 2.0.x systems ( seems so )
#include <linux/ucdrom.h>
#endif

#include <qobject.h>


/**
   Internal class to store per track information.
   This one is used by class Cdrom
*/
class CdTrackInfo
{
 public:
  CdTrackInfo() { _track = 0; _frames = 0; };
  CdTrackInfo( CdTrackInfo *trackx ) { _track = trackx->track(); _frames = trackx->trackFrames(); };
  ~CdTrackInfo() { };
  
  /**
     returns TRUE if something went wrong or no data had beed set
  */
  bool error() { return ( _track == 0 ); };
  /**
     track number the informations are about
  */
  int track() { return _track; };
  /**
     returns the track size in kBytes
  */
  int trackSize() { return ( _frames * ( CD_FRAMESIZE / 1024 ) ); };
  /**
     returns the track length in seconds 
  */
  int trackTime() { return ( _frames / 75 ); };
  /**
     returns a string showing the track time in the human readable format "mm:ss"
  */
  QString trackTimeString(); /* implemented in ocdrom_*.cpp ! */
  /**
     returns the frame count of this track
     One frame is defined to be 1/75 sec  -  this is system independent !
  */      
  long trackFrames() { return _frames; };
  /**
     returns a unique track id base on tracknumber
     and size
  */
  long trackId() { return ( _frames * _track ); };

  /**
     used internal by class Cdrom to store the data
  */
  void setTrack( int aTrack ) { _track = aTrack; };
  /**
     used internal by class Cdrom to store the data
  */
  void setFrames( long aFrames ) { _frames = aFrames; };
  /**
     sadsad
  */

 protected:
  int _track;
  long _frames;
};



/**
   This class provides a easy access to your cdrom. It's mainly used
   to access audio cds according to COLOR book format but can also
   be used to control basic cdrom drive functions for data cds.
*/
class Cdrom : public QObject
{
  Q_OBJECT
  
 public:
  /**
     Contructor - you have to provide the device name of any cd-rom drive.
     (e.g. "/dev/cdrom") - you can access both ATAPI and SCSI drives. 
     maybe some other ( old Mitsumi 1x speed/2x speed etc. ) work too.
  */
  Cdrom( QString aDeviceName );
  /**
     Destructor - nothing fancy...
  */
  ~Cdrom();
  
 public:
  /**
     error() returns an iternal error code. 0 is acording to "No Error", other
     codes mean:
     
     1. 
     2.
     3.
     ::
     ..
  */
  int error();                     /* error handling */
  /**
     equivalent function to error() but this one returns a error text !
     No error expands to "OK".
  */
  QString errorText();
  
  /**
     Eject the tray..
  */
  void openTray();                 /* tray control */
  /**
     close th tray..
  */
  void closeTray();
  /**
     is the drive ready to be used ?
     FALSE can have many reasons - some of them:

     - tray is open
     - cd is unreadable
     - hardware fault
     -... etc ...
  */
  bool isReady();
    
  /**
     returns TRUE if the media has changed after last call of this function.
  */
  int hasMediaChanged();
  /**
     returns TRUE if the drive tray is open.
  */
  int isTrayOpen();
    
  /**
     This function returns the numer of tracks written onto the inserted
     cdrom.
  */
  int trackCount();

  /**
     This function stores the track information into the passed 
     KTrackInfo object. Important: YOU MUST ALLOCATE MEMORY YOURSELF !
     Here is a small example:

     KTrackInfo *track;
     Cdrom *cdrom = new Cdrom( "/dev/cdrom" );
     
     if ( cdrom->isReady() && ( cdrom->trackCount > 0 ) )
       {
         cdrom->trackInfo( 1, track );
       };
  */
  void trackInfo( int nr, CdTrackInfo *trackInfo );
  
  void play( int track, int index );
  void stop();
  void pause();
  void resume();

 signals:
  void mediaChanged();

 protected:
  void readTocEntries();
  
  QString deviceName;
  int            cd_fd;
  int            errorCode;
  QString        errorMsg;
  cdrom_tocentry tocEntry[200];
};
  
  
#endif  
