/*
 * This is the Linux only implementation !
 * I currently don't have access to any other platform
 * but it would be great if YOU cold support driver
 * for different OSes [ *BSD // Solaris // etc. ]
 *
 * $Id: ocdrom_linux.cpp,v 1.2 1998/07/08 11:56:38 core Exp $
 *
 */

#include "ocdrom.h"
#include "ocdrom.moc"


/*****************************************************************************
 * Implementation of CdTrackInfo::trackTimeString. All other member functions
 *  are implemented in ocdrom.h !
 */
QString CdTrackInfo::trackTimeString()
{
  if ( _frames > 0 ) {
    int i;
    QString tmp;
    i = _frames / 75;
    tmp.sprintf( "%02d:%02d", i / 60, i % 60 );
    return tmp;       
  } else {
    return "00:00";
  }
}


/****************************************************************************
 * Okey, go on with the implementation of class Cdrom. All this is REALLY 
 * Linux specific - it won't compile on other platforms.
 */			 
Cdrom::Cdrom( QString aDeviceName )
  : QObject ( 0, "cdrom-device-driver" )
{
  deviceName = aDeviceName;

  cd_fd = open( deviceName, O_RDONLY );
  if ( cd_fd <= 0 ) {
    errorCode = 1;
    errorMsg = "Could not open device";
  } else {
    errorCode = 0;
    errorMsg = "OK";
  }
  readTocEntries();
}


Cdrom::~Cdrom()
{
  close( cd_fd );
}

int Cdrom::error()
{
  int i = errorCode;
  errorCode = 0;
  return i;
}

QString Cdrom::errorText()
{
  QString tmp = errorMsg;
  errorMsg = "OK";
  return tmp;
}


bool Cdrom::isReady()
{
  cdrom_tochdr hdr;
  if ( ioctl( cd_fd, CDROMREADTOCHDR, &hdr ) ) {
    errorCode = 2;               // cdrom NOT ready !
    errorMsg = "device not ready";
    return FALSE;
  } else {
    errorCode = 0;               // cdrom ready !
    errorMsg = "OK";
    return TRUE;
  }  
}

void Cdrom::openTray()
{
  if ( ioctl( cd_fd, CDROMEJECT ) == 0 ) {
    errorCode = 0;
    errorMsg = "OK";
  } else {
    errorCode = 2;
    errorMsg = "Could not eject tray";
  };  
}


void Cdrom::closeTray()
{
  if ( ioctl( cd_fd, CDROMCLOSETRAY ) == 0 ) {
    errorCode = 0;
    errorMsg = "OK";
  } else {
    errorCode = 2;
    errorMsg = "Could not close tray";
  };
}


int Cdrom::hasMediaChanged()
{
  errorCode = 0;
  errorMsg = "OK";
  if ( ioctl( cd_fd, CDROM_MEDIA_CHANGED ) == 1 ) {
    return TRUE;
  } else {
    return FALSE;
  }
}


int Cdrom::isTrayOpen()
{
  return !(isReady()) ;
}


int Cdrom::trackCount()
{
  int err;
  cdrom_tochdr hdr;
  
  err = ioctl( cd_fd, CDROMREADTOCHDR, &hdr );
  if ( err != 0 ) {
    errorCode = 2;
    errorMsg = "device not ready";
    return 0;
  } else {
    errorCode = 0;
    errorMsg = "OK";
    return hdr.cdth_trk1;
  }
}

  
void Cdrom::trackInfo ( int nr, CdTrackInfo *trackInfo )
{
  int count;
  int frames;
  
  count = trackCount();
  if ( errorCode == 0 ) {
    if ( nr <= count ) {
      frames = tocEntry[nr+1].cdte_addr.lba - tocEntry[nr].cdte_addr.lba;
      trackInfo->setTrack( nr );
      trackInfo->setFrames( frames );
    } else {
      errorCode = 3;
      errorMsg = "error reading track-info";
    }
  } else {
    errorCode = 3;
    errorMsg = "error reading track-info";
  };
}




void Cdrom::play( int track, int index )
{
}


void Cdrom::stop()
{
}


void Cdrom::pause()
{
}


void Cdrom::resume()
{
}

/********************************************************************
 * protected members
 */

void Cdrom::readTocEntries()
{
  int err;
  int count, i;
  
  errorCode = 0;
  errorMsg = "OK";
  
  count = trackCount();
  if ( errorCode == 0 ) {
    for ( i = 1; i <= count+1; i++ ) {
      if ( i == count+1 ) {
	tocEntry[i].cdte_track = CDROM_LEADOUT ;
      } else {
	tocEntry[i].cdte_track = i;
      };
      tocEntry[i].cdte_format = CDROM_LBA;
      err = ioctl( cd_fd, CDROMREADTOCENTRY, &tocEntry[i] );
      if ( err != 0 ) {
	i = count+2;          // abort loop !
	errorCode = 3;
	errorMsg = "error reading track-info";
      }
    }
  }
}

