/***************************************************************************
                          keasycddoc.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Feb  7 09:35:03 MET 1999
                                           
    copyright            : (C) 1999 by Marcel Borred                         
    email                : marcel.borreda@post.rwth-aachen.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <keasycddoc.h>
#include "keasycdview.h"
extern KEasyCDView *kview;
extern QString mkfiles;
extern QString audiofileslist;

KEasyCDDoc::KEasyCDDoc(QObject *parent, const char *filename):QObject(parent)
{
  bModified = false;

}

KEasyCDDoc::~KEasyCDDoc()
{
}

void KEasyCDDoc::deleteContents()
{
 setModified(false);

}

void KEasyCDDoc::saveFile()
{
 KMsgBox box;
 QString name =  KFileDialog::getSaveFileName(); 
 setModified(false);
if(name!=NULL)
{
 QFile f(name);
 if(f.exists()==TRUE)
 {

  if(box.yesNo(0,"Info","The file already exists. Do you want to overwrite the file?")==1)
  {
  f.remove();
  f.open( IO_WriteOnly);
  f.writeBlock( mkfiles, strlen(mkfiles) );
  f.putch(10);
  f.writeBlock( audiofileslist, strlen(audiofileslist) );
  f.close();
  }
  else
  saveFile();
 }
 else
 {
  f.open( IO_WriteOnly);
  f.writeBlock( mkfiles, strlen(mkfiles) );
  f.putch(10);
  f.writeBlock( audiofileslist, strlen(audiofileslist) );
  f.close();
  }
}
}

void KEasyCDDoc::openFile()
{
  QString name = KFileDialog::getOpenFileName();
  setModified(false);
  QFile f(name);
  f.open(IO_ReadOnly);
  QString fname="";
  char ch[]="\n";
  while(ch[0]!=-1)
  {

  ch[0]=f.getch();
  if(ch[0]!=' ' && ch[0]!='\n')
  fname.append(ch);
  if(ch[0]==' ')
  {

  kview->insertDataItem(fname);
  fname="";
  }
  if(ch[0]=='\n')
  while(ch[0]!=-1)
  {
  ch[0]=f.getch();
  if(ch[0]!=' ' && ch[0]!='\n')
  fname.append(ch);
  if(ch[0]==' ')
  {

  kview->insertAudioItem(fname);
  fname="";
  }
  }
  }
}

void KEasyCDDoc::setModified(bool m)
{
  bModified = m;
}









