#include "ProgressDlg.h"

//------------------------------------------------------------------------------------------

SyncLabel::SyncLabel(const char *text, QWidget *parent = 0, const char *name = 0)
	: QWidget(parent,name), Text(text)
{
	setBackgroundMode(NoBackground);
}

SyncLabel::SyncLabel(QWidget *parent = 0, const char *name = 0)
	: QWidget(parent,name), Text(0)
{
	setBackgroundMode(NoBackground);
}

SyncLabel::~SyncLabel()
{}

void SyncLabel::setText(const char *text)
{
	Text = text;
	update();
}

void SyncLabel::paintEvent(QPaintEvent *)
{
	QPainter	p;
	QPixmap		pm(width(),height());
	p.begin(&pm,parentWidget());
	p.fillRect(rect(),colorGroup().background());
	p.drawText(rect(),AlignVCenter|AlignLeft,Text.data());
	p.end();
	p.begin(this);
	p.drawPixmap(0,0,pm);
	p.end();
}

//------------------------------------------------------------------------------------------

SyncProgress::SyncProgress(int min, int max, QWidget *parent, const char *name)
	: QWidget(parent,name), Min(min), Max(max), Value(0)
{
	setBackgroundMode(NoBackground);
	PercentSet = FALSE;
}

SyncProgress::~SyncProgress()
{}

void SyncProgress::setValue(int val)
{
	PercentSet = FALSE;
	Value = val;
	update();
}

void SyncProgress::setPercent(int val)
{
	PercentSet = TRUE;
	Value = val;
	update();
}

void SyncProgress::paintEvent(QPaintEvent *)
{
	QPainter	p;
	QPixmap		pm(width(),height());
	p.begin(&pm);
	p.fillRect(rect(),white);
	QString		num;
	if (PercentSet) num.sprintf("%d bytes",Value);
	else {
		int	val = ((Value-Min)*width())/(Max-Min);
		p.fillRect(0,0,val,height(),darkBlue);
		num.sprintf("%d %%",(val*100)/width());
	}
	qDrawWinPanel(&p,rect(),colorGroup(),TRUE);
	p.setRasterOp(NotROP);
	p.setFont(QFont("helvetica",12,QFont::Black));
	p.drawText(rect(),AlignCenter,num.data());
	p.setRasterOp(CopyROP);
	p.end();
	p.begin(this);
	p.drawPixmap(0,0,pm);
	p.end();
}

//------------------------------------------------------------------------------------------

ProgressDlg::ProgressDlg(const char *labelText, const char *cancelText, int totalSteps, QWidget *parent, const char *name, bool modal, WFlags f)
	: QSemiModal(parent,name,modal,f), TotalSteps(totalSteps)
{
	Label = new SyncLabel(labelText,this);
	Label2 = new SyncLabel(this);
	Cancel = new QPushButton(cancelText,this);
	connect(Cancel,SIGNAL(clicked()),SIGNAL(cancelled()));
	connect(Cancel,SIGNAL(clicked()),SLOT(reset()));
	Bar = new SyncProgress(0,100,this);
	resize(400,150);
	int	space = (height()-90)/5;
	Label->setGeometry(10,space,width()-20,20);
	Label2->setGeometry(10,2*space+20,width()-20,20);
	Bar->setGeometry(10,3*space+40,width()-20,20);
	Cancel->setGeometry(width()-80,4*space+60,70,30);
	hide();
}

ProgressDlg::~ProgressDlg()
{}

void ProgressDlg::setProgress(int value)
{ Bar->setValue(value);}

void ProgressDlg::setAbsoluteValue(int value)
{ Bar->setPercent(value);}

void ProgressDlg::reset()
{
	Bar->setValue(0);
	Label->setText("");
	Label2->setText("");
	hide();
}

void ProgressDlg::setLabelText(const char *text, const char *text2)
{ Label->setText(text); Label2->setText(text2);}
