#ifndef _KBICONLIST_H_
#define _KBICONLIST_H_

#include "kflistbase.h"

// OLE
// The following definitions are used to calculate the position of icons, miniimages and text in the cells
// of the Big Icons Display
// for only use in kbiconlist.h
// ATTENTION: there are some dependencies between the defines, they must be resoanable


// cellheight when MiniImages are disabled:
#define HEIGHT_WITHOUT		80

// cellwidth when MiniImages are disabled:
#define WIDTH_WITHOUT           80

// cellheight when MiniImages are enabled:
#define HEIGHT_WITH_MINI_IMAGES 	100

// cellwidth when MiniImages are enabled:
#define WIDTH_WITH_MINI_IMAGES	88

// minimal distance from text, icon, miniImage to border:
#define BORDER_DIST	4

// height of the textfield:
#define TEXT_BOX_HEIGHT		20

// how many pixels above the bottom border the textfield starts:
#define TEXT_BOX_ABOVE_BOTTOM_BORDER 32

// how many pixels above the bottom border the icon will "end"
#define ICON_ABOVE_BOTTOM_BORDER    36

// ATTENTION if the LinkArrow will change dimensions these defines MUST be changed
// width of the LinkArrow:
#define LINK_ARROW_WIDTH          32

// height of the LinkArrow:
#define LINK_ARROW_HEIGHT         32
// OLE

class KBigIconList : public KFileListBase
{
	Q_OBJECT

public:
	KBigIconList(bool showMiniImages=false, QWidget *parent = 0, const char *name = 0, WFlags f = 0);

signals:
	void requestMiniImage(FileInfo*);

protected:
	virtual void paintCell(QPainter *p, int row, int col);
	virtual void resizeEvent(QResizeEvent *);
	virtual void getTablePosition(int index, int& row, int& col);
	virtual bool getItemCell(int row, int col, FileInfo **item, QPoint p);
	virtual QRect getItemTextRect(FileInfo *item);
	virtual void updateListSize();

// OLE
	bool ShowMiniImages;
// OLE
};

#endif
