#ifndef _KFLISTBASE_H_
#define _KFLISTBASE_H_

#include <qdir.h>
#include <qstring.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qlist.h>
#include "kfiled.h"
#include <qtableview.h>
#include "fileinfo.h"

class KFileListBase : public QTableView
{
	Q_OBJECT;

public:
	KFileListBase(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~KFileListBase();
	void setFileList(FileInfoList *list, bool keepSel = FALSE);
	void setLinkArrow(QPixmap *larrow);
	void setDNDIcon(QPixmap *dndicon);
	FileInfoList* getSelected() { return Selected;}
	void selectAll();
	void setSelection(FileInfoList& list);

signals:
	void renameItem(FileInfo *, const QString&);
	void openItem(FileInfo *);
	void changeSorting(QDir::SortSpec);
	void selectionChanged();
	void popup();

protected:
	virtual void updateListSize() = 0;
	void mousePressEvent(QMouseEvent *);
	void mouseMoveEvent(QMouseEvent *);
	void mouseReleaseEvent(QMouseEvent *);
	virtual void mouseDoubleClickEvent(QMouseEvent *e);
	virtual void getTablePosition(int index, int& row, int& col) = 0;
	virtual bool getItemCell(int row, int col, FileInfo **item, QPoint p) = 0;
	virtual QRect getItemTextRect(FileInfo *item) = 0;
	void addToSelection(FileInfo *item);
	void removeFromSelection(FileInfo *item);
	void removeSelection();

protected slots:
	void cancelEdit();
	void terminateEdit();

protected:
	FileInfoList		*FileList;
	QPixmap			*LinkArrow;
	QPixmap			*DNDIcon;
	FileInfoList		*Selected;
	KFileEdit		*Edit;
	bool			Editing;
	FileInfo		*CellEdited;
	FileInfo		*ItemClicked;
	bool			canDrag;
	int			press_x, press_y;
	QPixmap			Mask;
};

#endif
